<?php
require_once 'db_connection.php';

// Enable error reporting for debugging (remove in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Get rent_no from the URL
if (isset($_GET['rent_no'])) {
    $rent_no = $_GET['rent_no'];

    // Fetch rent_master data
    $query_master = "SELECT * FROM rent_master WHERE rent_no = ?";
    if ($stmt_master = $conn->prepare($query_master)) {
        $stmt_master->bind_param('i', $rent_no);
        $stmt_master->execute();
        $result_master = $stmt_master->get_result();
        if ($result_master->num_rows > 0) {
            $rent_master = $result_master->fetch_assoc();
        } else {
            echo "No rent record found.";
            exit;
        }
        $stmt_master->close();
    } else {
        echo "Error preparing statement: " . $conn->error;
        exit;
    }

    // Fetch rent_details data
    $query_details = "SELECT * FROM rent_details WHERE rent_no = ?";
    if ($stmt_details = $conn->prepare($query_details)) {
        $stmt_details->bind_param('i', $rent_no);
        $stmt_details->execute();
        $result_details = $stmt_details->get_result();
        $stmt_details->close();
    } else {
        echo "Error preparing rent_details statement: " . $conn->error;
        exit;
    }

    // Fetch rent_payment data
    $query_payment = "SELECT * FROM rent_payment WHERE rent_no = ?";
    if ($stmt_payment = $conn->prepare($query_payment)) {
        $stmt_payment->bind_param('i', $rent_no);
        $stmt_payment->execute();
        $result_payment = $stmt_payment->get_result();
        $stmt_payment->close();
    } else {
        echo "Error preparing rent_payment statement: " . $conn->error;
        exit;
    }
} else {
    echo "Rent No not provided.";
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Rent Form</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Including Font Awesome for icons, if needed -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <style>
        .section-header {
            background-color: #f8f9fa;
            padding: 10px;
            border: 1px solid #dee2e6;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .table th, .table td {
            vertical-align: middle;
        }
        .total-row {
            background-color: #f1f1f1;
            font-weight: bold;
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>

<div class="container mt-5">
    <h2 class="text-center">Edit Rent</h2>

    <form id="rent_form" method="POST" action="update_rent.php">
        <!-- Hidden field for rent_no -->
        <input type="hidden" name="rent_no" value="<?php echo htmlspecialchars($rent_no); ?>">

        <!-- Master Section (rent_master) -->
<div class="section-header">
    <h4>Rent Master</h4>
</div>
<div class="form-row">
    <div class="form-group col-md-3">
        <label for="salesman">Salesman1</label>
        <select class="form-control" id="salesman" name="salesman" required>
            <option value="">Select Salesman</option>
            <option value="SAHAN" <?php if ($rent_master['salesman'] == 'SAHAN') echo 'selected'; ?>>SAHAN</option>
            <option value="LAKSHIKA" <?php if ($rent_master['salesman'] == 'LAKSHIKA') echo 'selected'; ?>>LAKSHIKA</option>
            <option value="GIHAN" <?php if ($rent_master['salesman'] == 'GIHAN') echo 'selected'; ?>>GIHAN</option>
            <option value="SIR" <?php if ($rent_master['salesman'] == 'SIR') echo 'selected'; ?>>SIR</option>
            <option value="SACHINI" <?php if ($rent_master['salesman'] == 'SACHINI') echo 'selected'; ?>>SACHINI</option>
            <option value="SEETHA" <?php if ($rent_master['salesman'] == 'SEETHA') echo 'selected'; ?>>SEETHA</option>
        </select>
    </div>
    <div class="form-group col-md-3">
        <label for="name">Customer Name</label>
        <select class="form-control" id="name" name="name" required>
            <option value="">Select Customer</option>
            <?php
            // Fetch customers from customer_profile table
            $sql = "SELECT customer_name FROM customer_profile";
            $result_customers = $conn->query($sql);
            if ($result_customers->num_rows > 0) {
                while ($row = $result_customers->fetch_assoc()) {
                    $selected = ($rent_master['name'] == $row['customer_name']) ? 'selected' : '';
                    echo "<option value='" . htmlspecialchars($row['customer_name']) . "' $selected>" . htmlspecialchars($row['customer_name']) . "</option>";
                }
            }
            ?>
        </select>
    </div>
    <div class="form-group col-md-1">
        <label>&nbsp;</label>
        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#customerModal">+</button>
    </div>
    <div class="form-group col-md-3">
        <label for="date">Date</label>
        <input type="date" class="form-control" id="date" name="date" value="<?php echo htmlspecialchars($rent_master['date']); ?>" required>
    </div>
    <div class="form-group col-md-2">
        <label for="hand_over">Hand Over Date</label>
        <input type="date" class="form-control" id="hand_over" name="hand_over" value="<?php echo htmlspecialchars($rent_master['hand_over']); ?>" required>
    </div>
    <div class="form-group col-md-3">
        <label for="booking_date">Booking Date</label>
        <input type="date" class="form-control" id="booking_date" name="booking_date" value="<?php echo htmlspecialchars($rent_master['booking_date'] ?? ''); ?>" required>
    </div>
    <div class="form-group col-md-3">
        <label for="fiton_date">Fit-On Date</label>
        <input type="date" class="form-control" id="fiton_date" name="fiton_date" value="<?php echo htmlspecialchars($rent_master['fiton_date'] ?? ''); ?>" required>
    </div>
    <div class="form-group col-md-3">
        <label for="rent_action">Rent Action</label>
        <select class="form-control" id="rent_action" name="rent_action" required>
            <option value="">Select Action</option>
            <option value="Pending" <?php if ($rent_master['rent_action'] == 'Pending') echo 'selected'; ?>>Pending</option>
            <option value="Complete" <?php if ($rent_master['rent_action'] == 'Complete') echo 'selected'; ?>>Complete</option>
        </select>
    </div>
</div>
        <!-- Rent Details Section -->
        <div class="section-header">
            <h4>Rent Details</h4>
        </div>
        <table class="table table-bordered" id="rent_details_table">
            <thead>
                <tr>
                    <th>Item Code</th>
                    <th>Item Name</th>
                    <th>Quantity</th>
                    <th>Price</th>
                    <th>Status</th>
                    <th>Date</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $itemIndex = 0;
                while ($row_details = $result_details->fetch_assoc()) {
                    ?>
                    <tr>
                        <td><input type="text" name="items[<?php echo $itemIndex; ?>][item_code]" class="form-control item_code" value="<?php echo htmlspecialchars($row_details['item_code']); ?>" required></td>
                        <td><input type="text" name="items[<?php echo $itemIndex; ?>][item_name]" class="form-control item_name" value="<?php echo htmlspecialchars($row_details['item_name']); ?>" readonly required></td>
                        <td><input type="number" name="items[<?php echo $itemIndex; ?>][quantity]" class="form-control quantity" value="<?php echo htmlspecialchars($row_details['quantity']); ?>" min="1" required></td>
                        <td><input type="number" name="items[<?php echo $itemIndex; ?>][price]" class="form-control price" value="<?php echo htmlspecialchars($row_details['price']); ?>" min="0" required></td>
                        <td>
                            <select name="items[<?php echo $itemIndex; ?>][status]" class="form-control" required>
                                <option value="Rent" <?php echo ($row_details['status'] == 'Rent') ? 'selected' : ''; ?>>Rent</option>
                                <option value="Return" <?php echo ($row_details['status'] == 'Return') ? 'selected' : ''; ?>>Return</option>
                            </select>
                        </td>
                        <td><input type="date" name="items[<?php echo $itemIndex; ?>][date]" class="form-control" value="<?php echo htmlspecialchars($row_details['date']); ?>" required></td>
                        <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                    </tr>
                    <?php
                    $itemIndex++;
                }
                ?>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_row">Add Item</button>

        <!-- Rent Payment Section -->
        <div class="section-header">
            <h4>Rent Payment</h4>
        </div>
        <table class="table table-bordered" id="rent_payment_table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Payment</th>
                    <th>Payment Type</th>
                    <th>Remark</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $paymentIndex = 0;
                while ($row_payment = $result_payment->fetch_assoc()) {
                    ?>
                    <tr>
                        <td><input type="date" name="payments[<?php echo $paymentIndex; ?>][date]" class="form-control" value="<?php echo htmlspecialchars($row_payment['date']); ?>" required></td>
                        <td><input type="number" name="payments[<?php echo $paymentIndex; ?>][payment]" class="form-control payment" value="<?php echo htmlspecialchars($row_payment['payment']); ?>" min="0" required></td>
                        <td>
                            <select name="payments[<?php echo $paymentIndex; ?>][payment_type]" class="form-control" required>
                                <option value="Cash" <?php echo ($row_payment['payment_type'] == 'Cash') ? 'selected' : ''; ?>>Cash</option>
                                <option value="Credit" <?php echo ($row_payment['payment_type'] == 'Credit') ? 'selected' : ''; ?>>Credit</option>
                                <option value="Credit Card" <?php echo ($row_payment['payment_type'] == 'Credit Card') ? 'selected' : ''; ?>>Credit Card</option>
                                <option value="Bank Transfer" <?php echo ($row_payment['payment_type'] == 'Bank Transfer') ? 'selected' : ''; ?>>Bank Transfer</option>
                                <option value="Cheque" <?php echo ($row_payment['payment_type'] == 'Cheque') ? 'selected' : ''; ?>>Cheque</option>
                            </select>
                        </td>
                        <td><input type="text" name="payments[<?php echo $paymentIndex; ?>][remark]" class="form-control" value="<?php echo htmlspecialchars($row_payment['remark']); ?>"></td>
                        <td><button type="button" class="btn btn-danger remove-payment-row">Remove</button></td>
                    </tr>
                    <?php
                    $paymentIndex++;
                }
                ?>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_payment_row">Add Payment</button>

        <!-- Bottom Section of the Form -->
        <div class="form-group row mt-4">
            <label for="total_amount" class="col-sm-2 col-form-label">Total Amount</label>
            <div class="col-sm-4">
                <input type="number" id="total_amount" name="total_amount" class="form-control" value="<?php echo htmlspecialchars($rent_master['total_amount']); ?>" readonly>
            </div>
        </div>

        <div class="form-group row">
            <label for="discount" class="col-sm-2 col-form-label">Discount</label>
            <div class="col-sm-4">
                <input type="number" id="discount" name="discount" class="form-control" value="<?php echo htmlspecialchars($rent_master['discount']); ?>" min="0">
            </div>
        </div>

        <div class="form-group row">
            <label for="balance" class="col-sm-2 col-form-label">Balance</label>
            <div class="col-sm-4">
                <input type="number" id="balance" name="balance" class="form-control" value="<?php echo htmlspecialchars($rent_master['balance']); ?>" readonly>
            </div>
        </div>

        <div class="form-group text-center">
            <button type="submit" class="btn btn-success">Update Rent</button>
        </div>
    </form>
</div>

<!-- Modal for Adding Customer -->
<div class="modal fade" id="customerModal" tabindex="-1" role="dialog" aria-labelledby="customerModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form id="customer_form" method="POST" action="create_customer.php">
                <div class="modal-header">
                    <h5 class="modal-title" id="customerModalLabel">Add Customer</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                
                <div class="modal-body">
                    <div class="form-group">
                        <label for="customer_name">Customer Name</label>
                        <input type="text" class="form-control" id="customer_name" name="customer_name" required>
                    </div>
                    <div class="form-group">
                        <label for="customer_address">Customer Address</label>
                        <input type="text" class="form-control" id="customer_address" name="customer_address" required>
                    </div>
                    <div class="form-group">
                        <label for="customer_phone">Customer Phone</label>
                        <input type="text" class="form-control" id="customer_phone" name="customer_phone" required>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Add Customer</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    var itemIndex = <?php echo $itemIndex; ?>;
    var paymentIndex = <?php echo $paymentIndex; ?>;

    // Add new rent item row
    $('#add_row').click(function() {
        var newRow = `<tr>
            <td><input type="text" name="items[${itemIndex}][item_code]" class="form-control item_code" required></td>
            <td><input type="text" name="items[${itemIndex}][item_name]" class="form-control item_name" readonly required></td>
            <td><input type="number" name="items[${itemIndex}][quantity]" class="form-control quantity" value="1" min="1" required></td>
            <td><input type="number" name="items[${itemIndex}][price]" class="form-control price" value="0" min="0" required></td>
            <td>
                <select name="items[${itemIndex}][status]" class="form-control" required>
                    <option value="Rent">Rent</option>
                    <option value="Return">Return</option>
                </select>
            </td>
            <td><input type="date" name="items[${itemIndex}][date]" class="form-control" required></td>
            <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
        </tr>`;
        $('#rent_details_table tbody').append(newRow);
        itemIndex++;
    });

    // Add new payment row
    $('#add_payment_row').click(function() {
        var newPaymentRow = `<tr>
            <td><input type="date" name="payments[${paymentIndex}][date]" class="form-control" required></td>
            <td><input type="number" name="payments[${paymentIndex}][payment]" class="form-control payment" value="0" min="0" required></td>
            <td>
                <select name="payments[${paymentIndex}][payment_type]" class="form-control" required>
                    <option value="Cash">Cash</option>
                    <option value="Credit">Credit</option>
                    <option value="Credit Card">Credit Card</option>
                    <option value="Bank Transfer">Bank Transfer</option>
                    <option value="Cheque">Cheque</option>
                </select>
            </td>
            <td><input type="text" name="payments[${paymentIndex}][remark]" class="form-control"></td>
            <td><button type="button" class="btn btn-danger remove-payment-row">Remove</button></td>
        </tr>`;
        $('#rent_payment_table tbody').append(newPaymentRow);
        paymentIndex++;
    });

    // Remove row functionality for items and payments
    $(document).on('click', '.remove-row', function() {
        $(this).closest('tr').remove();
        updateTotalAmount(); // Update the total when a row is removed
    });

    $(document).on('click', '.remove-payment-row', function() {
        $(this).closest('tr').remove();
        updateTotalAmount(); // Update the total when a payment row is removed
    });

    // Trigger auto-fill when item_code is entered
    $(document).on('blur', '.item_code', function() {
        var itemCode = $(this).val().trim();
        var row = $(this).closest('tr');

        if (itemCode !== "") {
            $.ajax({
                url: 'get_item_details_renta.php',
                method: 'POST',
                data: { item_code: itemCode },
                dataType: 'json',
                success: function(data) {
                    if (data.success) {
                        row.find('.item_name').val(data.item_name);
                        row.find('.price').val(data.price);
                        updateTotalAmount(); // Recalculate total when item details are filled
                    } else {
                        alert('Item not found.');
                        row.find('.item_name').val('');
                        row.find('.price').val(0);
                        updateTotalAmount(); // Recalculate total in case of failure
                    }
                },
                error: function() {
                    alert('Error fetching item details.');
                }
            });
        } else {
            row.find('.item_name').val('');
            row.find('.price').val(0);
            updateTotalAmount();
        }
    });

    // Update total, discount, and balance dynamically
    function updateTotalAmount() {
        var total = 0;
        $('#rent_details_table tbody tr').each(function() {
            var quantity = parseFloat($(this).find('.quantity').val()) || 0;
            var price = parseFloat($(this).find('.price').val()) || 0;
            total += (quantity * price);
        });

        $('#total_amount').val(total.toFixed(2));

        // Calculate balance after discount and payments
        var discount = parseFloat($('#discount').val()) || 0;
        var paymentsTotal = calculateTotalPayments();
        var balance = total - (discount + paymentsTotal);
        $('#balance').val(balance.toFixed(2));
    }

    // Function to calculate total payments
    function calculateTotalPayments() {
        var totalPayments = 0;
        $('#rent_payment_table tbody tr').each(function() {
            var payment = parseFloat($(this).find('.payment').val()) || 0;
            totalPayments += payment;
        });
        return totalPayments;
    }

    // Calculate total and balance on quantity/price/payment/discount change
    $(document).on('input', '.quantity, .price, .payment, #discount', function() {
        updateTotalAmount();
    });

    // Initialize total amount calculation
    updateTotalAmount();
});
</script>

</body>
</html>
