<?php
require_once 'db_connection.php';

if (isset($_POST['item_code'])) {
    $item_code = $_POST['item_code'];
    $stmt = $conn->prepare("SELECT item_name, item_price FROM item_profile WHERE item_code = ?");
    $stmt->bind_param("s", $item_code);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $stmt->bind_result($item_name, $item_price);
        $stmt->fetch();
        $response = array('success' => true, 'item_name' => $item_name, 'item_price' => $item_price);
    } else {
        $response = array('success' => false);
    }

    $stmt->close();
    $conn->close();

    echo json_encode($response);
}
?>
