<?php
require_once 'db_connection.php'; // Your DB connection file

if (isset($_POST['item_code'])) {
    $item_code = $_POST['item_code'];

    $sql = "SELECT item_name, item_price FROM item_profile WHERE item_code = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $item_code);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $item = $result->fetch_assoc();
        $response = [
            'success' => true,
            'item_name' => $item['item_name'],
            'price' => $item['item_price']
        ];
    } else {
        $response = ['success' => false];
    }

    echo json_encode($response);
}
?>
