<?php
require_once 'db_connection.php'; // Include your database connection file

// Check if the form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // Retrieve form data
    $date = $_POST['date'];
    $status = $_POST['status'];
    $description = $_POST['description'];
    $remark = $_POST['remark'];
    $amount = $_POST['amount'];

    // Prepare and bind
    $stmt = $conn->prepare("INSERT INTO income_expenses (date, status, description, remark, amount) VALUES (?, ?, ?, ?, ?)");
    if ($stmt) {
        $stmt->bind_param("ssssd", $date, $status, $description, $remark, $amount);

        // Execute the statement
        if ($stmt->execute()) {
            echo "<script>alert('Record saved successfully!');</script>";
            echo "<script>window.location.href = 'list_income_expenses.php';</script>"; // Redirect to a list page (to be created)
        } else {
            echo "<script>alert('Error: Could not save the record.');</script>";
            echo "<script>window.history.back();</script>";
        }

        // Close the statement
        $stmt->close();
    } else {
        echo "<script>alert('Error: Could not prepare the statement.');</script>";
        echo "<script>window.history.back();</script>";
    }
}

// Close the database connection
$conn->close();
?>
