<?php
require_once 'db_connection.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rent_no = $_POST['rent_no'];
    
    // Check if h_date is empty and set it to NULL if it is
    $h_date = !empty($_POST['h_date']) ? $_POST['h_date'] : NULL;

    // Update rent_master table
    $sql_update_master = "UPDATE rent_master SET
                            salesman = ?,
                            name = ?,                          
                            status = ?,
                            date = ?,
                            book_date = ?,
                            return_date = ?,
                            h_date = ?,       /* Updated h_date handling */
                            total_amount = ?,
                            discount = ?,
                            balance = ?
                          WHERE rent_no = ?";
                          
    $stmt_master = $conn->prepare($sql_update_master);

    // Use "s" for string types and bind NULL as a string for h_date
    $stmt_master->bind_param("sssssssdddi",
        $_POST['salesman'],
        $_POST['name'],
        $_POST['status'],
        $_POST['date'],
        $_POST['book_date'],
        $_POST['return_date'],
        $h_date,  // This can now be NULL if empty
        $_POST['total_amount'],
        $_POST['discount'],
        $_POST['balance'],
        $rent_no
    );

    $stmt_master->execute();

    // Delete existing rent details and insert updated ones
    $sql_delete_details = "DELETE FROM rent_details WHERE rent_no = ?";
    $stmt_delete_details = $conn->prepare($sql_delete_details);
    $stmt_delete_details->bind_param("i", $rent_no);
    $stmt_delete_details->execute();

    $sql_insert_details = "INSERT INTO rent_details (rent_no, item_code, item_name, quantity, price, subtotal, remarks) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt_insert_details = $conn->prepare($sql_insert_details);

    foreach ($_POST['items'] as $item) {
        $stmt_insert_details->bind_param("issidss",
            $rent_no,
            $item['item_code'],
            $item['item_name'],
            $item['quantity'],
            $item['price'],
            $item['subtotal'],
            $item['remarks']
        );
        $stmt_insert_details->execute();
    }

    // Delete existing rent payments and insert updated ones
    $sql_delete_payments = "DELETE FROM rent_payment WHERE rent_no = ?";
    $stmt_delete_payments = $conn->prepare($sql_delete_payments);
    $stmt_delete_payments->bind_param("i", $rent_no);
    $stmt_delete_payments->execute();

    $sql_insert_payments = "INSERT INTO rent_payment (rent_no, date, payment, payment_type, remark) VALUES (?, ?, ?, ?, ?)";
    $stmt_insert_payments = $conn->prepare($sql_insert_payments);

    foreach ($_POST['payments'] as $payment) {
        $stmt_insert_payments->bind_param("isiss",
            $rent_no,
            $payment['date'],
            $payment['payment'],
            $payment['payment_type'],
            $payment['remark']
        );
        $stmt_insert_payments->execute();
    }

    // Redirect or display a success message
    header("Location: list_rents.php");
    exit;
}
?>
