<?php
require_once 'db_connection.php';

if (isset($_GET['cus_rtn_id'])) {
    $cus_rtn_id = $_GET['cus_rtn_id'];

    // Fetch master data
    $stmt = $conn->prepare("SELECT * FROM customer_return_master WHERE cus_rtn_id = ?");
    $stmt->bind_param("i", $cus_rtn_id);
    $stmt->execute();
    $masterResult = $stmt->get_result()->fetch_assoc();

    // Fetch details data
    $stmt = $conn->prepare("SELECT * FROM customer_details WHERE cus_rtn_id = ?");
    $stmt->bind_param("i", $cus_rtn_id);
    $stmt->execute();
    $detailsResult = $stmt->get_result();
} else {
    die("Invalid request.");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Customer Return Form</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .form-section {
            margin-bottom: 30px;
        }
        .form-section h3 {
            margin-bottom: 20px;
            color: #007bff;
        }
        .table th, .table td {
            vertical-align: middle;
        }
        .table th {
            background-color: #f8f9fa;
        }
        .btn-add-row {
            background-color: #007bff;
            color: #fff;
        }
        .btn-remove-row {
            background-color: #dc3545;
            color: #fff;
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
    <div class="container">
        <h2 class="text-center mb-4">Edit Customer Return Form</h2>

        <form action="update_cus_rtn.php" method="POST">
            <input type="hidden" name="cus_rtn_id" value="<?php echo $cus_rtn_id; ?>">

            <!-- Master Section -->
            <div class="form-section">
                <h3>Master Section</h3>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="invoice_no">Invoice No</label>
                        <input type="text" class="form-control" id="invoice_no" name="invoice_no" value="<?php echo $masterResult['invoice_no']; ?>" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="customer_name">Customer Name</label>
                        <select class="form-control" id="customer_name" name="customer_name" required>
                            <?php
                            $result = $conn->query("SELECT customer_name FROM customer_profile");
                            while ($row = $result->fetch_assoc()) {
                                $selected = $row['customer_name'] == $masterResult['customer_name'] ? "selected" : "";
                                echo "<option value='" . $row['customer_name'] . "' $selected>" . $row['customer_name'] . "</option>";
                            }
                            ?>
                        </select>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="date">Date</label>
                        <input type="date" class="form-control" id="date" name="date" value="<?php echo $masterResult['date']; ?>" required>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="salesman">Salesman</label>
                        <select class="form-control" id="salesman" name="salesman" required>
                            <option value="Nimal" <?php echo $masterResult['salesman'] == 'Nimal' ? 'selected' : ''; ?>>Nimal</option>
                            <option value="Kamal" <?php echo $masterResult['salesman'] == 'Kamal' ? 'selected' : ''; ?>>Kamal</option>
                            <option value="Senarath" <?php echo $masterResult['salesman'] == 'Senarath' ? 'selected' : ''; ?>>Senarath</option>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Details Section -->
            <div class="form-section">
                <h3>Details Section</h3>
                <table class="table table-bordered" id="details-table">
                    <thead>
                        <tr>
                            <th>Item Code</th>
                            <th>Item Name</th>
                            <th>Quantity</th>
                            <th>Amount</th>
                            <th>Subtotal</th>
                            <th>Remark</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $detailsResult->fetch_assoc()): ?>
                        <tr>
                            <td><input type="text" class="form-control item-code" name="item_code[]" value="<?php echo $row['item_code']; ?>" required></td>
                            <td><input type="text" class="form-control item-name" name="item_name[]" value="<?php echo $row['item_name']; ?>" readonly></td>
                            <td><input type="number" class="form-control quantity" value ="<?php echo $row['quantity']; ?>" name="quantity[]" min="1" required></td>
                            <td><input type="text" class="form-control amount" name="amount[]" value="<?php echo $row['amount']; ?>" readonly></td>
                            <td><input type="text" class="form-control subtotal" name="subtotal[]" value="<?php echo $row['subtotal']; ?>" readonly></td>
                            <td><input type="text" class="form-control" name="remark[]" value="<?php echo $row['remark']; ?>"></td>
                            <td><button type="button" class="btn btn-danger btn-remove-row">&times;</button></td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
                <button type="button" class="btn btn-success btn-add-row">Add Row</button>
            </div>

            <!-- Summary Section -->
            <div class="form-section">
                <div class="form-row">
                    <div class="form-group col-md-6 offset-md-6">
                        <label for="rtn_value">Total Return Value</label>
                        <input type="text" class="form-control" id="rtn_value" name="rtn_value" value="<?php echo $masterResult['rtn_value']; ?>" readonly>
                    </div>
                </div>
            </div>

            <div class="text-right">
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
        </form>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script>
        $(document).ready(function () {
            // Add new row
            $('.btn-add-row').on('click', function () {
                let newRow = `<tr>
                    <td><input type="text" class="form-control item-code" name="item_code[]" required></td>
                    <td><input type="text" class="form-control item-name" name="item_name[]" readonly></td>
                    <td><input type="number" class="form-control quantity" value ="1" name="quantity[]" min="1" required></td>
                    <td><input type="text" class="form-control amount" name="amount[]" readonly></td>
                    <td><input type="text" class="form-control subtotal" name="subtotal[]" readonly></td>
                    <td><input type="text" class="form-control" name="remark[]"></td>
                    <td><button type="button" class="btn btn-danger btn-remove-row">&times;</button></td>
                </tr>`;
                $('#details-table tbody').append(newRow);
            });

            // Remove row
            $(document).on('click', '.btn-remove-row', function () {
                $(this).closest('tr').remove();
                calculateTotal();
            });

            // Autofill item name and amount based on item code
            $(document).on('blur', '.item-code', function () {
                let itemCode = $(this).val();
                let $row = $(this).closest('tr');
                
                $.ajax({
                    url: 'fetch_item_cus_rtn_details.php',
                    method: 'POST',
                    data: { item_code: itemCode },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            $row.find('.item-name').val(response.item_name);
                            $row.find('.amount').val(response.item_price);
                            calculateSubtotal($row);
                        } else {
                            alert('Item not found');
                        }
                    }
                });
            });

            // Calculate subtotal when quantity changes
            $(document).on('input', '.quantity', function () {
                let $row = $(this).closest('tr');
                calculateSubtotal($row);
            });

            function calculateSubtotal($row) {
                let quantity = $row.find('.quantity').val();
                let amount = $row.find('.amount').val();
                let subtotal = quantity * amount;
                $row.find('.subtotal').val(subtotal.toFixed(2));
                calculateTotal();
            }

            function calculateTotal() {
                let total = 0;
                $('.subtotal').each(function () {
                    total += parseFloat($(this).val());
                });
                $('#rtn_value').val(total.toFixed(2));
            }

            // Calculate initial total
            calculateTotal();
        });
    </script>
</body>
</html>
