<?php
require_once 'db_connection.php';

$search = "";
if (isset($_POST['search'])) {
    $search = $_POST['search'];
    $sql = "SELECT * FROM job_cards WHERE id = '$search'";
} else {
    $sql = "SELECT * FROM job_cards";
}
$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Job Card List</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<?php require_once 'menu.html'; ?>
<div class="container mt-5">
    <h2>Job Card List</h2>
    <form method="post" class="form-inline mb-3">
        <input type="text" name="search" class="form-control mr-2" placeholder="Search by Job ID" value="<?php echo $search; ?>">
        <button type="submit" class="btn btn-primary">Search</button>
    </form>
    <a href="job_card.php" class="btn btn-primary mb-3">Create New Job Card</a>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Job ID</th>
                <th>Customer Name</th>
                <th>NIC No</th>
                <th>Date</th>
                <th>Total Payment</th>
                <th>Balance</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php while($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?php echo $row['id']; ?></td>
                <td><?php echo $row['name']; ?></td>
                <td><?php echo $row['nic_no']; ?></td>
                <td><?php echo $row['date']; ?></td>
                <td><?php echo $row['total_payment']; ?></td>
                <td><?php echo $row['balance']; ?></td>
                <td>
                    <a href="view_job_card.php?id=<?php echo $row['id']; ?>" class="btn btn-info">View</a>
                    <a href="edit_job_card.php?id=<?php echo $row['id']; ?>" class="btn btn-warning">Edit</a>
                    <a href="delete_job_card.php?id=<?php echo $row['id']; ?>" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this job card?');">Delete</a>
                </td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
</body>
</html>
<?php $conn->close(); ?>
