<?php
require_once 'db_connection.php';

if (!isset($_GET['order_no'])) {
    die("Error: Order No not provided.");
}

$order_no = $_GET['order_no'];

// Fetch Order Master
$sql_master = "SELECT * FROM order_master WHERE order_no = ?";
$stmt_master = $conn->prepare($sql_master);
$stmt_master->bind_param("i", $order_no);
$stmt_master->execute();
$result_master = $stmt_master->get_result();
$order_master = $result_master->fetch_assoc();
$stmt_master->close();

// Fetch Order Details
$sql_details = "SELECT * FROM order_details WHERE order_no = ?";
$stmt_details = $conn->prepare($sql_details);
$stmt_details->bind_param("i", $order_no);
$stmt_details->execute();
$result_details = $stmt_details->get_result();
$order_details = $result_details->fetch_all(MYSQLI_ASSOC);
$stmt_details->close();

// Fetch Order Status
$sql_status = "SELECT * FROM order_status WHERE order_no = ?";
$stmt_status = $conn->prepare($sql_status);
$stmt_status->bind_param("i", $order_no);
$stmt_status->execute();
$result_status = $stmt_status->get_result();
$order_status = $result_status->fetch_all(MYSQLI_ASSOC);
$stmt_status->close();

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Order</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">View Order</h2>
    
    <!-- Order Master -->
    <div class="section-header">
        <h4>Order Master</h4>
    </div>
    <table class="table table-bordered">
        <tr>
            <th>Order No</th>
            <td><?php echo $order_master['order_no']; ?></td>
        </tr>
        <tr>
            <th>Job No</th>
            <td><?php echo $order_master['job_no']; ?></td>
        </tr>
        <tr>
            <th>Date</th>
            <td><?php echo $order_master['date']; ?></td>
        </tr>
        <tr>
            <th>Handover Date</th>
            <td><?php echo $order_master['handover_date']; ?></td>
        </tr>
        <tr>
            <th>Person 1</th>
            <td><?php echo $order_master['person1']; ?></td>
        </tr>
        <tr>
            <th>Person 2</th>
            <td><?php echo $order_master['person2']; ?></td>
        </tr>
        <tr>
            <th>Person 3</th>
            <td><?php echo $order_master['person3']; ?></td>
        </tr>
        <tr>
            <th>Remark</th>
            <td><?php echo $order_master['remark']; ?></td>
        </tr>
    </table>

    <!-- Order Details -->
    <div class="section-header">
        <h4>Order Details</h4>
    </div>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Item Code</th>
                <th>Item Name</th>
                <th>Quantity</th>
                <th>Remark</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($order_details as $detail): ?>
                <tr>
                    <td><?php echo $detail['item_code']; ?></td>
                    <td><?php echo $detail['item_name']; ?></td>
                    <td><?php echo $detail['quantity']; ?></td>
                    <td><?php echo $detail['remark']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <!-- Order Status -->
    <div class="section-header">
        <h4>Order Status</h4>
    </div>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Status Date</th>
                <th>Description</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($order_status as $status): ?>
                <tr>
                    <td><?php echo $status['status_date']; ?></td>
                    <td><?php echo $status['description']; ?></td>
                    <td><?php echo $status['status']; ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
