<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$role = $_SESSION['role'];

if ($role !== 'admin' && $role !== 'user') {
    echo "Access denied.";
    exit();
}

require_once 'db_connection.php';

if (!isset($_GET['item_id'])) {
    die("Error: Item ID not provided.");
}

$item_id = $_GET['item_id'];

$sql = "SELECT * FROM item_profile WHERE item_id='$item_id'";
$result = $conn->query($sql);

if ($result->num_rows == 0) {
    die("Error: Item not found.");
}

$row = $result->fetch_assoc();

// Fetch categories from the database
$sql_categories = "SELECT category_name FROM category_profile";
$result_categories = $conn->query($sql_categories);
$categories = [];
if ($result_categories->num_rows > 0) {
    while ($category_row = $result_categories->fetch_assoc()) {
        $categories[] = $category_row['category_name'];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Item Profile</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2>Edit Item Profile</h2>
    <form action="process_edit_item.php" method="post">
        <input type="hidden" name="item_id" value="<?php echo $row['item_id']; ?>">
        
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_code">Item Code:</label>
                <input type="text" id="item_code" name="item_code" class="form-control" value="<?php echo $row['item_code']; ?>" >
            </div>
            <div class="form-group col-md-6">
                <label for="item_name">Item Name:</label>
                <input type="text" id="item_name" name="item_name" class="form-control" value="<?php echo $row['item_name']; ?>" required>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_price">Item Price:</label>
                <input type="number" id="item_price" name="item_price" class="form-control" value="<?php echo $row['item_price']; ?>" step="0.01" required>
            </div>
            <div class="form-group col-md-6">
                <label for="item_category">Item Category:</label>
                <select id="item_category" name="item_category" class="form-control" required>
                    <option value="">Select a Category</option>
                    <?php foreach ($categories as $category): ?>
                        <option value="<?php echo htmlspecialchars($category); ?>" <?php if ($row['item_category'] == $category) echo 'selected'; ?>>
                            <?php echo htmlspecialchars($category); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_type">Item Type:</label>
                <select id="item_type" name="item_type" class="form-control" required>
                    <option value="Raw Material" <?php if ($row['item_type'] == 'Raw Material') echo 'selected'; ?>>Raw Material</option>
                    <option value="Rent Item" <?php if ($row['item_type'] == 'Rent Item') echo 'selected'; ?>>Rent Item</option>
                    <option value="Sell Item" <?php if ($row['item_type'] == 'Sell Item') echo 'selected'; ?>>Sell Item</option>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="create_date">Create Date:</label>
                <input type="date" id="create_date" name="create_date" class="form-control" value="<?php echo $row['create_date']; ?>" required>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_description">Item Description:</label>
                <textarea id="item_description" name="item_description" class="form-control" rows="3"><?php echo $row['item_description']; ?></textarea>
            </div>

            <div class="form-group col-md-6">
                <label for="unit_ok">Unit:</label>
                 <select id="unit_ok" name="unit_ok" class="form-control" required>
                        <option value="Each" <?php if ($row['unit_ok'] == 'Each') echo 'selected'; ?>>Each</option>
                        <option value="Yards" <?php if ($row['unit_ok'] == 'Yards') echo 'selected'; ?>>Yards</option>
                        <option value="M" <?php if ($row['unit_ok'] == 'M') echo 'selected'; ?>>M</option>
                        <option value="KG" <?php if ($row['unit_ok'] == 'KG') echo 'selected'; ?>>KG</option>                        
                 </select>
            </div>
        </div>    

        <button type="submit" class="btn btn-success">Update Item Profile</button>
       
    </form>
</div>
</body>
</html>

<?php
$conn->close();
?>
