<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Job Card</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</head>
<body>
<?php require_once 'menu.html'; ?>
<div class="container mt-5">
    <h2>Create Job Card</h2>
    <form id="job_card_form" method="POST" action="process_job_card.php">
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="name">Customer Name:</label>
                <input type="text" class="form-control" id="name" name="name" required>
            </div>
            <div class="form-group col-md-6">
                <label for="address">Address:</label>
                <input type="text" class="form-control" id="address" name="address" required>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="nic_no">NIC No:</label>
                <input type="text" class="form-control" id="nic_no" name="nic_no" required>
            </div>
            <div class="form-group col-md-6">
                <label for="date">Date:</label>
                <input type="date" class="form-control" id="date" name="date" required>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="fiton_date">Fit-on Date:</label>
                <input type="date" class="form-control" id="fiton_date" name="fiton_date" required>
            </div>
            <div class="form-group col-md-6">
                <label for="final_fiton_date">Final Fit-on Date:</label>
                <input type="date" class="form-control" id="final_fiton_date" name="final_fiton_date" required>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="payment">Total Payment:</label>
                <input type="number" step="0.01" class="form-control" id="payment" name="payment" required readonly>
            </div>
            <div class="form-group col-md-6">
                <label for="balance">Balance:</label>
                <input type="number" step="0.01" class="form-control" id="balance" name="balance" required readonly>
            </div>
            <div class="form-group col-md-6">
                <label for="job_action">Job Action:</label>
                <select id="job_action" name="job_action" class="form-control" required>
                    <option value="Pending">Pending</option>
                    <option value="Complete">Complete</option>
                </select>
            </div>
        </div>
        
        <h4>Job Items</h4>
        <table class="table table-bordered" id="job_items_table">
            <thead>
                <tr>
                    <th>Item Code</th>
                    <th>Item Name</th>
                    <th>Payment</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="text" name="items[0][item_code]" class="form-control item-code" required></td>
                    <td><input type="text" name="items[0][item_name]" class="form-control item-name" required readonly></td>
                    <td><input type="number" step="0.01" name="items[0][payment]" class="form-control item-payment" required></td>
                    <td><button type="button" class="btn btn-danger remove-item-row">Remove</button></td>
                </tr>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_item_row">Add Item</button>
        
        <h4>Job Payments</h4>
        <table class="table table-bordered" id="job_payments_table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Payment Type</th>
                    <th>Payment Amount</th>
                    <th>Payment By</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="date" name="payments[0][date]" class="form-control" required></td>
                    <td>
                        <select name="payments[0][payment_type]" class="form-control" required>
                            <option value="Advance">Advance</option>
                            <option value="Balance">Balance</option>
                        </select>
                    </td>
                    <td><input type="number" step="0.01" name="payments[0][payment_amount]" class="form-control payment-amount" required></td>
                    <td>
                        <select name="payments[0][payment_by]" class="form-control" required>
                            <option value="Cash">Cash</option>
                            <option value="Check">Check</option>
                            <option value="Credit">Credit</option>
                            <option value="Credit Card">Credit Card</option>
                            <option value="Online Transfer">Online Transfer</option>
                        </select>
                    </td>
                    <td><button type="button" class="btn btn-danger remove-payment-row">Remove</button></td>
                </tr>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_payment_row">Add Payment</button>
        
        <br><br>
        <button type="submit" class="btn btn-success">Save Job Card</button>
    </form>
</div>

<script>
$(document).ready(function() {
    var item_index = 1;
    var payment_index = 1;

    function updateTotalPayment() {
        var total = 0;
        $('.item-payment').each(function() {
            total += parseFloat($(this).val()) || 0;
        });
        $('#payment').val(total.toFixed(2));
        updateBalance();
    }

    function updateBalance() {
        var totalPayment = parseFloat($('#payment').val()) || 0;
        var totalPaymentsMade = 0;
        $('.payment-amount').each(function() {
            totalPaymentsMade += parseFloat($(this).val()) || 0;
        });
        var balance = totalPayment - totalPaymentsMade;
        $('#balance').val(balance.toFixed(2));
    }

    $('#add_item_row').click(function() {
        var new_item_row = '<tr>' +
            '<td><input type="text" name="items[' + item_index + '][item_code]" class="form-control item-code" required></td>' +
            '<td><input type="text" name="items[' + item_index + '][item_name]" class="form-control item-name" required readonly></td>' +
            '<td><input type="number" step="0.01" name="items[' + item_index + '][payment]" class="form-control item-payment" required></td>' +
            '<td><button type="button" class="btn btn-danger remove-item-row">Remove</button></td>' +
            '</tr>';
        $('#job_items_table tbody').append(new_item_row);
        item_index++;
        updateTotalPayment();
    });

    $('#add_payment_row').click(function() {
        var new_payment_row = '<tr>' +
            '<td><input type="date" name="payments[' + payment_index + '][date]" class="form-control" required></td>' +
            '<td>' +
                '<select name="payments[' + payment_index + '][payment_type]" class="form-control" required>' +
                    '<option value="Advance">Advance</option>' +
                    '<option value="Balance">Balance</option>' +
                '</select>' +
            '</td>' +
            '<td><input type="number" step="0.01" name="payments[' + payment_index + '][payment_amount]" class="form-control payment-amount" required></td>' +
            '<td>' +
                '<select name="payments[' + payment_index + '][payment_by]" class="form-control" required>' +
                    '<option value="Cash">Cash</option>' +
                    '<option value="Check">Check</option>' +
                    '<option value="Credit">Credit</option>' +
                    '<option value="Credit Card">Credit Card</option>' +
                    '<option value="Online Transfer">Online Transfer</option>' +
                '</select>' +
            '</td>' +
            '<td><button type="button" class="btn btn-danger remove-payment-row">Remove</button></td>' +
            '</tr>';
        $('#job_payments_table tbody').append(new_payment_row);
        payment_index++;
        updateBalance();
    });

    $(document).on('click', '.remove-item-row', function() {
        $(this).closest('tr').remove();
        updateTotalPayment();
    });

    $(document).on('click', '.remove-payment-row', function() {
        $(this).closest('tr').remove();
        updateBalance();
    });

    $(document).on('input', '.item-payment', function() {
        updateTotalPayment();
    });

    $(document).on('input', '.payment-amount', function() {
        updateBalance();
    });

    $(document).on('blur', '.item-code', function() {
        var item_code = $(this).val();
        var item_name_input = $(this).closest('tr').find('.item-name');

        $.ajax({
            url: 'get_item_name.php',
            type: 'POST',
            data: { item_code: item_code },
            dataType: 'json',
            success: function(response) {
                if (response.item_name) {
                    item_name_input.val(response.item_name);
                } else {
                    item_name_input.val('');
                }
            }
        });
    });

    updateTotalPayment();
    updateBalance();
});
</script>
</body>
</html>
