<?php
include 'db_connection.php';

$sql = "SELECT * FROM customer_profile";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer List</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2>Customer List</h2>
    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Address</th>
                <th>Email</th>
                <th>Remark</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                echo "<tr>
                        <td>".$row['customer_id']."</td>
                        <td>".$row['customer_name']."</td>
                        <td>".$row['customer_address']."</td>
                        <td>".$row['customer_email']."</td>
                        <td>".$row['remark']."</td>
                        <td>
                            <a href='edit_customer.php?id=".$row['customer_id']."' class='btn btn-sm btn-warning'>Edit</a> 
                            <a href='delete_customer.php?id=".$row['customer_id']."' class='btn btn-sm btn-danger' onclick=\"return confirm('Are you sure you want to delete this customer?');\">Delete</a> 
                            <a href='view_customer.php?id=".$row['customer_id']."' class='btn btn-sm btn-info'>View</a>
                        </td>
                    </tr>";
            }
        } else {
            echo "<tr><td colspan='6' class='text-center'>No customers found</td></tr>";
        }
        ?>
        </tbody>
    </table>
    <br>
    <a href="add_customer.php" class="btn btn-primary">Add New Customer</a>
</div>
</body>
</html>

<?php $conn->close(); ?>
