<?php
require_once 'db_connection.php';

$sql = "SELECT * FROM supplier";
$result = $conn->query($sql);

$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
    <title>Supplier List</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2>Supplier List</h2>
    <table class="table table-bordered">
        <thead class="thead-dark">
            <tr>
                <th>ID</th>
                <th>Supplier Name</th>
                <th>Supplier NIC</th>
                <th>Supplier Address</th>
                <th>Email</th>
                <th>Contact Number</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php
        if ($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                echo "<tr>
                        <td>{$row['id']}</td>
                        <td>{$row['supplier_name']}</td>
                        <td>{$row['supplier_nic']}</td>
                        <td>{$row['supplier_address']}</td>
                        <td>{$row['email']}</td>
                        <td>{$row['contact_number']}</td>
                        <td>
                            <a href='edit_supplier.php?id={$row['id']}' class='btn btn-warning btn-sm'>Edit</a> 
                            <a href='delete_supplier.php?id={$row['id']}' class='btn btn-danger btn-sm' onclick=\"return confirm('Are you sure you want to delete this supplier?');\">Delete</a>
                        </td>
                      </tr>";
            }
        } else {
            echo "<tr><td colspan='7'>No suppliers found</td></tr>";
        }
        ?>
        </tbody>
    </table>
    <br>
    <a href="create_supplier.php" class="btn btn-primary">Create New Supplier</a>
</div>
</body>
</html>
