<?php
require_once 'db_connection_pdo.php';

// Get Job Card ID from URL
$jobCardId = isset($_GET['job_card_id']) ? (int)$_GET['job_card_id'] : 0;

// If no Job Card ID, redirect back to the main report
if ($jobCardId == 0) {
    header('Location: pending_jobs_report.php');
    exit();
}

// Query to get Job Card details
$sqlJobCard = "
SELECT 
    jc.id AS Job_Card_ID,
    jc.name AS Customer_Name,
    jc.date AS Job_Date,
    jc.fiton_date AS Fiton_Date,
    jc.final_fiton_date AS Final_Fiton_Date,
    jc.total_payment AS Total_Payment,
    jc.balance AS Balance
FROM 
    job_cards jc
WHERE 
    jc.id = :job_card_id
";

$stmtJobCard = $pdo->prepare($sqlJobCard);
$stmtJobCard->execute([':job_card_id' => $jobCardId]);
$jobCardDetails = $stmtJobCard->fetch(PDO::FETCH_ASSOC);

// Query to get Job Items
$sqlJobItems = "
SELECT 
    item_code,
    item_name,
    quantity,
    payment
FROM 
    job_items
WHERE 
    job_card_id = :job_card_id
";

$stmtJobItems = $pdo->prepare($sqlJobItems);
$stmtJobItems->execute([':job_card_id' => $jobCardId]);
$jobItems = $stmtJobItems->fetchAll(PDO::FETCH_ASSOC);

// Query to get Job Payments
$sqlJobPayments = "
SELECT 
    date,
    payment_type,
    payment_amount,
    payment_by
FROM 
    job_payments
WHERE 
    job_card_id = :job_card_id
";

$stmtJobPayments = $pdo->prepare($sqlJobPayments);
$stmtJobPayments->execute([':job_card_id' => $jobCardId]);
$jobPayments = $stmtJobPayments->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Job Card Details</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h1 class="mb-4">Job Card Details (ID: <?php echo htmlspecialchars($jobCardDetails['Job_Card_ID']); ?>)</h1>
    
    <!-- Job Card Details -->
    <div class="mb-4">
        <h4>Customer Name: <?php echo htmlspecialchars($jobCardDetails['Customer_Name']); ?></h4>
        <p><strong>Job Date:</strong> <?php echo htmlspecialchars($jobCardDetails['Job_Date']); ?></p>
        <p><strong>Fiton Date:</strong> <?php echo htmlspecialchars($jobCardDetails['Fiton_Date']); ?></p>
        <p><strong>Final Fiton Date:</strong> <?php echo htmlspecialchars($jobCardDetails['Final_Fiton_Date']); ?></p>
        <p><strong>Total Payment:</strong> <?php echo htmlspecialchars(number_format($jobCardDetails['Total_Payment'], 2)); ?></p>
        <p><strong>Remaining Balance:</strong> <?php echo htmlspecialchars(number_format($jobCardDetails['Balance'], 2)); ?></p>
    </div>

    <!-- Job Items -->
    <h3>Job Items</h3>
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Item Code</th>
                <th>Item Name</th>
                <th>Quantity</th>
                <th>Payment</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($jobItems) > 0): ?>
                <?php foreach ($jobItems as $item): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($item['item_code']); ?></td>
                        <td><?php echo htmlspecialchars($item['item_name']); ?></td>
                        <td><?php echo htmlspecialchars($item['quantity']); ?></td>
                        <td><?php echo htmlspecialchars(number_format($item['payment'], 2)); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="4" class="text-center">No items found for this job card.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <!-- Job Payments -->
    <h3>Job Payments</h3>
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Date</th>
                <th>Payment Type</th>
                <th>Payment Amount</th>
                <th>Payment By</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($jobPayments) > 0): ?>
                <?php foreach ($jobPayments as $payment): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($payment['date']); ?></td>
                        <td><?php echo htmlspecialchars($payment['payment_type']); ?></td>
                        <td><?php echo htmlspecialchars(number_format($payment['payment_amount'], 2)); ?></td>
                        <td><?php echo htmlspecialchars($payment['payment_by']); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="4" class="text-center">No payments found for this job card.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <a href="pending_jobs_report.php" class="btn btn-primary">Back to Report</a>
</div>
</body>
</html>
