<?php
include 'db_connection.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Customer List</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</head>
<body>
<?php require_once 'menu.html'; ?>
<div class="container mt-5">

    <h2>Customer List</h2>
    
    <div class="d-flex mb-4">
        <input class="form-control me-2" type="search" id="searchBox" placeholder="Search by Name, NIC, or TP">
    </div>
    
    <a href="add_customer.php" class="btn btn-primary mb-3">Add New Customer</a>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>NIC</th>
                <th>TP</th>
                <th>Remark</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody id="customerTable">
        <!-- Results will be loaded here via AJAX -->
        </tbody>
    </table>
    
</div>

<script>
    $(document).ready(function(){
        // Function to load data based on search input
        function loadCustomers(query) {
            $.ajax({
                url: "search_customers.php",
                method: "GET",
                data: { search: query },
                success: function(data) {
                    $("#customerTable").html(data);
                }
            });
        }

        // Initial load with no filter
        loadCustomers('');

        // Real-time search as user types
        $("#searchBox").on("keyup", function() {
            var searchQuery = $(this).val();
            loadCustomers(searchQuery);
        });
    });
</script>
</body>
</html>
