<?php
require_once 'db_connection.php';

$sql = "SELECT * FROM employees";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Employee Management</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">Employee Profiles</h2>
    <a href="add_employee.php" class="btn btn-success mb-3">Add Employee</a>
    <table class="table table-bordered table-striped">
        <thead class="thead-dark">
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>NIC No</th>
            <th>TP No</th>
            <th>Email</th>
            <th>Position</th>
            <th>Actions</th>
        </tr>
        </thead>
        <tbody>
        <?php
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                echo "<tr>";
                echo "<td>{$row['id']}</td>";
                echo "<td>{$row['name']}</td>";
                echo "<td>{$row['nic_no']}</td>";
                echo "<td>{$row['tp_no']}</td>";
                echo "<td>{$row['email']}</td>";
                echo "<td>{$row['position']}</td>";
                echo "<td>
                        <a href='view_employee.php?id={$row['id']}' class='btn btn-info'>View</a>
                        <a href='edit_employee.php?id={$row['id']}' class='btn btn-warning'>Edit</a>
                        <a href='delete_employee.php?id={$row['id']}' class='btn btn-danger' onclick='return confirm(\"Are you sure?\")'>Delete</a>
                      </td>";
                echo "</tr>";
            }
        } else {
            echo "<tr><td colspan='7' class='text-center'>No Employees Found</td></tr>";
        }
        ?>
        </tbody>
    </table>
</div>
</body>
</html>
<?php $conn->close(); ?>
