<?php
require_once 'db_connection.php'; // Your DB connection file

// Initialize query
$sql = "SELECT * FROM rent_master WHERE 1=1 ORDER BY rent_no DESC";

// Check if search form is submitted
if (isset($_GET['search'])) {
    $rent_no = $_GET['rent_no'];
    $start_date = $_GET['start_date'];
    $end_date = $_GET['end_date'];

    // Filter by rent number
    if (!empty($rent_no)) {
        $sql .= " AND rent_no = '$rent_no'";
    }

    // Filter by date range
    if (!empty($start_date) && !empty($end_date)) {
        $sql .= " AND date BETWEEN '$start_date' AND '$end_date'";
    }
}

$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rent Transactions</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
<?php require_once 'menu.html';?>

<div class="container mt-5">
    <h2 class="text-center">Rent Transactions</h2>

    <!-- Search Form -->
    <form method="GET" action="list_rent.php" class="mb-3">
        <div class="form-row">
            <div class="col-md-3">
                <input type="text" name="rent_no" class="form-control" placeholder="Rent No" value="<?php echo isset($_GET['rent_no']) ? $_GET['rent_no'] : ''; ?>">
            </div>
            <div class="col-md-3">
                <input type="date" name="start_date" class="form-control" value="<?php echo isset($_GET['start_date']) ? $_GET['start_date'] : ''; ?>">
            </div>
            <div class="col-md-3">
                <input type="date" name="end_date" class="form-control" value="<?php echo isset($_GET['end_date']) ? $_GET['end_date'] : ''; ?>">
            </div>
            <div class="col-md-3">
                <button type="submit" name="search" class="btn btn-primary">Search</button>
            </div>
        </div>
    </form>

    <a href="rent.php" class="btn btn-primary mb-3">Create New Rent</a>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Rent No</th>
                <th>Salesman</th>
                <th>Customer</th>
                <th>Date</th>
                <th>Total Amount</th>
                <th>Balance</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) { ?>
                <tr>
                    <td><?php echo $row['rent_no']; ?></td>
                    <td><?php echo $row['salesman']; ?></td>
                    <td><?php echo $row['name']; ?></td>
                    <td><?php echo $row['date']; ?></td>
                    <td><?php echo $row['total_amount']; ?></td>
                    <td><?php echo $row['balance']; ?></td>
                    <td>
                        <a href="view_rent.php?rent_no=<?php echo $row['rent_no']; ?>" class="btn btn-info btn-sm">Print</a>
                        <a href="view_rent_print.php?rent_no=<?php echo $row['rent_no']; ?>" class="btn btn-success btn-sm">Print 2</a>
                        <a href="edit_rent.php?rent_no=<?php echo $row['rent_no']; ?>" class="btn btn-warning btn-sm">Edit</a>
                        <a href="delete_rent.php?rent_no=<?php echo $row['rent_no']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</a>
                    </td>
                </tr>
            <?php } } else { ?>
            <tr>
                <td colspan="7" class="text-center">No rent transactions found.</td>
            </tr>
            <?php } ?>
        </tbody>
    </table>
</div>

</body>
</html>
