<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$role = $_SESSION['role'];

if ($role !== 'admin' && $role !== 'user') {
    echo "Access denied.";
    exit();
}

require_once 'db_connection.php';

// Get search filters from POST request
$search_item_code = $_POST['search_item_code'] ?? '';
$search_category = $_POST['search_category'] ?? '';
$search_colour = $_POST['search_colour'] ?? '';
$search_size = $_POST['search_size'] ?? '';

// Build SQL query based on filters
$sql = "SELECT * FROM item_profile WHERE 1=1";

if (!empty($search_item_code)) {
    $sql .= " AND item_code LIKE '%" . $conn->real_escape_string($search_item_code) . "%'";
}
if (!empty($search_category)) {
    $sql .= " AND item_category LIKE '%" . $conn->real_escape_string($search_category) . "%'";
}
if (!empty($search_colour)) {
    $sql .= " AND item_colour LIKE '%" . $conn->real_escape_string($search_colour) . "%'";
}
if (!empty($search_size)) {
    $sql .= " AND item_size LIKE '%" . $conn->real_escape_string($search_size) . "%'";
}

// Execute the query
$result = $conn->query($sql);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Printable Report</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        @media print {
            .no-print { display: none; }
        }
    </style>
</head>
<body>
<div class="container mt-4">
    <h2 class="text-center">Item Report</h2>

    <!-- Total records count -->
    <?php
    $record_count = $result->num_rows;
    if ($record_count > 0): ?>
        <p class="text-info text-center">Total records found: <?php echo $record_count; ?></p>
    <?php else: ?>
        <p class="text-danger text-center">No records found.</p>
    <?php endif; ?>



    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Item Code</th>
                <th>Item Name</th>
                <th>Item Price</th>
                <th>Item Category</th>
                <th>Item Colour</th>
                <th>Item Size</th>
            </tr>
        </thead>
        <tbody>
            <?php if ($result->num_rows > 0): ?>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $row['item_code']; ?></td>
                        <td><?php echo $row['item_name']; ?></td>
                        <td><?php echo $row['item_price']; ?></td>
                        <td><?php echo $row['item_category']; ?></td>
                        <td><?php echo $row['item_colour']; ?></td>
                        <td><?php echo $row['item_size']; ?></td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="6" class="text-center">No items found</td></tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="text-center no-print">
        <button class="btn btn-primary" onclick="window.print();">Print</button>
        <a href="list_items.php" class="btn btn-secondary">Back</a>
    </div>
</div>
</body>
</html>
<?php
$conn->close();
?>
