
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Rent Form</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <style>
        .section-header {
            background-color: #f8f9fa;
            padding: 10px;
            border: 1px solid #dee2e6;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .table th, .table td {
            vertical-align: middle;
        }
        .total-row {
            background-color: #f1f1f1;
            font-weight: bold;
        }
        .centa {
  display: flex;
  justify-content: center;
  align-items: center;
  padding: 20px;
}
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">Create Rent</h2>

    <form id="rent_form" method="POST" action="create_rent.php">
        <!-- Master Section (rent_master) -->
        <div class="section-header">
            <h4>Rent Master</h4>
        </div>
        <div class="form-row">
            <div class="form-group col-md-2">
                <label for="salesman">Salesman</label>
                <select class="form-control" id="salesman" name="salesman" required>
                    <option value="">Select Salesman</option>
                    <option value="SAHAN">SAHAN</option>
                    <option value="LAKSHIKA">LAKSHIKA</option>
                    <option value="GIHAN">GIHAN</option>
                    <option value="SIR">SIR</option>
                    <option value="SACHINI">SACHINI</option>
                    <option value="SEETHA">SEETHA</option>
                </select>
            </div>
            <div class="form-group col-md-3">
              <label for="customer_name">Customer Name</label>
            <input list="customer_list" id="name" name="name" class="form-control" required placeholder="Start typing customer name..." autocomplete="off">

                <datalist id="customer_list">
                <?php
                require_once 'db_connection.php';

                // Fetch customer names from the database
                 $sql = "SELECT *  FROM customer_profile order by customer_name";
                 $result = $conn->query($sql);

                  if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo "<option value='" . $row['customer_name'] . "'>" 
                             . $row['customer_name'] . " [NIC: " . $row['nic_no'] . "] [TP: " . $row['cus_tp'] . "]</option>";
                    }
    }
    ?>
</datalist>


            </div>
            <div class="form-group col-md-1 centa">            
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#customerModal">+</button>
            </div>
            <div class="form-group col-md-2">
    <label for="date">Date</label>
    <input type="date" class="form-control" id="date" name="date" required>
</div>
<div class="form-group col-md-2">
    <label for="booking_date">Booking Date</label>
    <input type="date" class="form-control" id="booking_date" name="booking_date" required>
</div>

<div class="form-group col-md-2">
    <label for="fiton_date">Fiton Date</label>
    <input type="date" class="form-control" id="fiton_date" name="fiton_date" required>
</div>

<div class="form-group col-md-2">
    <label for="hand_over">Hand Over Date</label>
    <input type="date" class="form-control" id="hand_over" name="hand_over" required>
</div>


<div class="form-group col-md-2">
    <label for="rent_action">Rent Action</label>
    <select class="form-control" id="rent_action" name="rent_action" required>
        <option value="pending">Pending</option>
        <option value="complete">Complete</option>
    </select>
</div>


        </div>

      <!-- Rent Details Section -->
<div class="section-header">
    <h4>Rent Details</h4>
</div>
<table class="table table-bordered" id="rent_details_table">
    <thead>
        <tr>
            <th>Item Code</th>
            <th>Item Name</th>
            <th>Quantity</th>
            <th>Price</th>
            <th>Status</th>
            <th>Date</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><input type="text" name="items[0][item_code]" class="form-control item_code" required></td>
            <td><input type="text" name="items[0][item_name]" class="form-control item_name" readonly required></td>
            <td><input type="number" name="items[0][quantity]" class="form-control quantity" value="1" min="1" required></td>
            <td><input type="number" name="items[0][price]" class="form-control price" value="0" min="0" required></td>
            <td>
                <select name="items[0][status]" class="form-control" required>
                    <option value="Rent">Rent</option>
                    <option value="Return">Return</option>
                </select>
            </td>
            <td><input type="date" name="items[0][date]" class="form-control" required></td>
            <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
        </tr>
    </tbody>
</table>
<button type="button" class="btn btn-primary" id="add_row">Add Item</button>


        <!-- Rent Payment Section -->
        <div class="section-header">
            <h4>Rent Payment</h4>
        </div>
        <table class="table table-bordered" id="rent_payment_table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Payment</th>
                    <th>Payment Type</th>
                    <th>Remark</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td><input type="date" name="payments[0][date]" class="form-control" required></td>
                    <td><input type="number" name="payments[0][payment]" class="form-control payment" value="0" min="0" required></td>
                    <td>
                        <select name="payments[0][payment_type]" class="form-control" required>
                            <option value="Cash">Cash</option>
                            <option value="Credit">Credit</option>
                            <option value="Credit Card">Credit Card</option>
                            <option value="Bank Transfer">Bank Transfer</option>
                            <option value="Cheque">Cheque</option>
                        </select>
                    </td>
                    <td><input type="text" name="payments[0][remark]" class="form-control"></td>
                    <td><button type="button" class="btn btn-danger remove-payment-row">Remove</button></td>
                </tr>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_payment_row">Add Payment</button>

       <!-- Bottom Section of the Form -->
<div class="form-group row">
    <label for="total_amount" class="col-sm-2 col-form-label">Total Amount</label>
    <div class="col-sm-4">
        <input type="number" id="total_amount" name="total_amount" class="form-control" value="0" readonly>
    </div>
</div>

<div class="form-group row">
    <label for="discount" class="col-sm-2 col-form-label">Discount</label>
    <div class="col-sm-4">
        <input type="number" id="discount" name="discount" class="form-control" value="0" min="0">
    </div>
</div>

<div class="form-group row">
    <label for="balance" class="col-sm-2 col-form-label">Balance</label>
    <div class="col-sm-4">
        <input type="number" id="balance" name="balance" class="form-control" value="0" readonly>
    </div>
</div>


        <button type="submit" class="btn btn-success">Submit</button>
    </form>
</div>

<!-- Customer Modal -->
<div class="modal fade" id="customerModal" tabindex="-1" role="dialog" aria-labelledby="customerModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="customerModalLabel">Select Customer</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="customerIframe" src="add_customer.php" style="width: 100%; height: 400px; border: none;"></iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" id="selectCustomerBtn">Select</button>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    var itemIndex = 1;
    var paymentIndex = 1;

    // Add new rent item row
    $('#add_row').click(function() {
        var newRow = `<tr>
            <td><input type="text" name="items[${itemIndex}][item_code]" class="form-control item_code" required></td>
            <td><input type="text" name="items[${itemIndex}][item_name]" class="form-control item_name" readonly required></td>
            <td><input type="number" name="items[${itemIndex}][quantity]" class="form-control quantity" value="1" min="1" required></td>
            <td><input type="number" name="items[${itemIndex}][price]" class="form-control price" value="0" min="0" required></td>
            <td>
                <select name="items[${itemIndex}][status]" class="form-control" required>
                    <option value="Rent">Rent</option>
                    <option value="Return">Return</option>
                </select>
            </td>
            <td><input type="date" name="items[${itemIndex}][date]" class="form-control" required></td>
            <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
        </tr>`;
        $('#rent_details_table tbody').append(newRow);
        itemIndex++;
    });

    // Add new payment row
    $('#add_payment_row').click(function() {
        var newPaymentRow = `<tr>
            <td><input type="date" name="payments[${paymentIndex}][date]" class="form-control" required></td>
            <td><input type="number" name="payments[${paymentIndex}][payment]" class="form-control payment" value="0" min="0" required></td>
            <td>
                <select name="payments[${paymentIndex}][payment_type]" class="form-control" required>
                    <option value="Cash">Cash</option>
                    <option value="Credit">Credit</option>
                    <option value="Credit Card">Credit Card</option>
                    <option value="Bank Transfer">Bank Transfer</option>
                    <option value="Cheque">Cheque</option>
                </select>
            </td>
            <td><input type="text" name="payments[${paymentIndex}][remark]" class="form-control"></td>
            <td><button type="button" class="btn btn-danger remove-payment-row">Remove</button></td>
        </tr>`;
        $('#rent_payment_table tbody').append(newPaymentRow);
        paymentIndex++;
    });

    // Remove row functionality for items and payments
    $(document).on('click', '.remove-row', function() {
        $(this).closest('tr').remove();
        updateTotalAmount(); // Update the total when a row is removed
    });

    $(document).on('click', '.remove-payment-row', function() {
        $(this).closest('tr').remove();
        updateTotalAmount(); // Update the total when a payment row is removed
    });

    // Trigger auto-fill when item_code is entered
    $(document).on('blur', '.item_code', function() {
        var itemCode = $(this).val();
        var row = $(this).closest('tr');
        
        if (itemCode !== "") {
            $.ajax({
                url: 'get_item_details_renta.php',
                method: 'POST',
                data: { item_code: itemCode },
                dataType: 'json',
                success: function(data) {
                    if (data.success) {
                        row.find('.item_name').val(data.item_name);
                        row.find('.price').val(data.price);
                        updateTotalAmount(); // Recalculate total when item details are filled
                    } else {
                        alert('Item not found.');
                        row.find('.item_name').val('');
                        row.find('.price').val(0);
                    }
                },
                error: function() {
                    alert('Error fetching item details.');
                }
            });
        }
    });

    // Update total, discount, and balance dynamically
    function updateTotalAmount() {
        var total = 0;
        $('#rent_details_table tbody tr').each(function() {
            var quantity = parseFloat($(this).find('.quantity').val());
            var price = parseFloat($(this).find('.price').val());
            total += (quantity * price);
        });

        $('#total_amount').val(total);

        // Calculate balance after discount and payments
        var discount = parseFloat($('#discount').val()) || 0;
        var paymentsTotal = calculateTotalPayments();
        var balance = total - (discount + paymentsTotal);
        $('#balance').val(balance);
    }

    // Function to calculate total payments
    function calculateTotalPayments() {
        var totalPayments = 0;
        $('#rent_payment_table tbody tr').each(function() {
            var payment = parseFloat($(this).find('.payment').val()) || 0;
            totalPayments += payment;
        });
        return totalPayments;
    }

    // Calculate total and balance on quantity/price/payment/discount change
    $(document).on('input', '.quantity, .price, .payment, #discount', function() {
        updateTotalAmount();
    });

    // Initialize total amount calculation
    updateTotalAmount();
});

</script>


</body>
</html>
