<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'db_connection.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sales Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .table-container {
            margin-top: 20px;
        }
        .total-row {
            font-weight: bold;
            background-color: #e9ecef;
        }
        @media print {
            body {
                background-color: white;
            }
            .filter-form, .btn-clear, .btn-print {
                display: none;
            }
     .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
        <h1 class="text-center mt-4">Sales Report</h1>
        
        <form method="GET" class="row g-3 align-items-center filter-form">
            <div class="col-md-3">
                <label for="document" class="form-label">Document Type</label>
                <select name="document" id="document" class="form-select">
                    <option value="">All</option>
                    <option value="Invoice">Invoice</option>
                    <option value="Job">Job</option>
                    <option value="Rent">Rent</option>
                </select>
            </div>
            <div class="col-md-3">
                <label for="salesman" class="form-label">Salesman</label>
                <input type="text" name="salesman" id="salesman" class="form-control" placeholder="Enter Salesman">
            </div>
            <div class="col-md-3">
                <label for="date_start" class="form-label">Date Range</label>
                <div class="input-group">
                    <input type="date" name="date_start" id="date_start" class="form-control">
                    <span class="input-group-text">to</span>
                    <input type="date" name="date_end" id="date_end" class="form-control">
                </div>
            </div>
            <div class="col-md-3">
                <label for="type" class="form-label">Payment Type</label>
                <select name="type" id="type" class="form-select">
                    <option value="">All</option>
                    <option value="Cash">Cash</option>
                    <option value="Advance">Advance</option>
                </select>
            </div>
            <div class="col-12 d-flex justify-content-end">
                <button type="submit" class="btn btn-primary me-2">Filter</button>
                <a href="salse_report.php" class="btn btn-secondary">Clear</a>
                <button type="button" class="btn btn-success btn-print" onclick="window.print()">Print</button>
            </div>
        </form>

        <div class="table-container">
            <table class="table table-striped table-bordered">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Document</th>
                        <th>Document No</th>
                        <th>Salesman</th>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Payment</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $document = $_GET['document'] ?? '';
                    $salesman = $_GET['salesman'] ?? '';
                    $date_start = $_GET['date_start'] ?? '';
                    $date_end = $_GET['date_end'] ?? '';
                    $type = $_GET['type'] ?? '';

                    $conditions = [];

                    if ($document) {
                        $conditions[] = "document = '$document'";
                    }
                    if ($salesman) {
                        $conditions[] = "salesman LIKE '%$salesman%'";
                    }
                    if ($date_start && $date_end) {
                        $conditions[] = "date BETWEEN '$date_start' AND '$date_end'";
                    }
                    if ($type) {
                        $conditions[] = "type = '$type'";
                    }

                    $whereClause = '';
                    if (!empty($conditions)) {
                        $whereClause = 'WHERE ' . implode(' AND ', $conditions);
                    }

                    $query = "
                        SELECT * FROM (
                            SELECT 
                                invoice_payment_details.id, 
                                'Invoice' AS document, 
                                invoice_payment_details.invoice_no AS doc_no, 
                                invoice_master.salesman, 
                                invoice_payment_details.payment_date AS date, 
                                invoice_payment_details.payment_type AS type, 
                                invoice_payment_details.payment 
                            FROM 
                                invoice_payment_details 
                            JOIN 
                                invoice_master 
                            ON 
                                invoice_payment_details.invoice_no = invoice_master.invoice_no
                        
                            UNION ALL
                        
                            SELECT 
                                job_payments.id, 
                                'Job' AS document, 
                                job_payments.job_card_id AS doc_no, 
                                job_cards.salsman AS salesman, 
                                job_payments.date, 
                                job_payments.payment_type AS type, 
                                job_payments.payment_amount AS payment 
                            FROM 
                                job_payments 
                            JOIN 
                                job_cards 
                            ON 
                                job_payments.job_card_id = job_cards.id
                        
                            UNION ALL
                        
                            SELECT 
                                rent_payment.id, 
                                'Rent' AS document, 
                                rent_payment.rent_no AS doc_no, 
                                rent_master.salesman, 
                                rent_payment.date, 
                                rent_payment.payment_type AS type, 
                                rent_payment.payment 
                            FROM 
                                rent_payment 
                            JOIN 
                                rent_master 
                            ON 
                                rent_payment.rent_no = rent_master.rent_no
                        ) AS combined_data
                        $whereClause
                        ORDER BY date;
                    ";

                    $result = $conn->query($query);

                    if (!$result) {
                        die("Query Error: " . $conn->error);
                    }

                    $totalPayment = 0;
                    $rowNumber = 1; // Start row numbering from 1

                    if ($result->num_rows > 0) {
                        while ($row = $result->fetch_assoc()) {
                            echo "<tr>";
                            echo "<td>" . $rowNumber++ . "</td>";
                            echo "<td>" . $row['document'] . "</td>";
                            echo "<td>" . $row['doc_no'] . "</td>";
                            echo "<td>" . $row['salesman'] . "</td>";
                            echo "<td>" . $row['date'] . "</td>";
                            echo "<td>" . $row['type'] . "</td>";
                            echo "<td class='text-end'>" . number_format($row['payment'], 2) . "</td>";
                            echo "</tr>";

                            $totalPayment += $row['payment'];
                        }
                    } else {
                        echo "<tr><td colspan='7' class='text-center'>No records found</td></tr>";
                    }
                    ?>
                </tbody>
                <tfoot>
                    <tr class="total-row">
                        <td colspan="6" class="text-end">Total Payment</td>
                        <td class="text-end">$<?= number_format($totalPayment, 2) ?></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    
   
        
    <script>
        document.querySelector('.btn-clear').addEventListener('click', () => {
            document.getElementById('document').value = '';
            document.getElementById('salesman').value = '';
            document.getElementById('date_start').value = '';
            document.getElementById('date_end').value = '';
            document.getElementById('type').value = '';
        });
    </script>
</body>
</html>
