<?php
require_once 'db_connection.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve date from form submission
    $date = $_POST['date'];
    $item_codes = $_POST['item_code'];
    $item_names = $_POST['item_name'];
    $quantities = $_POST['quantity'];
    $statuses = $_POST['status'];
    $tasks = $_POST['task'];
    $remarks = $_POST['remark'];

    // Prepare statement to insert multiple rows into the database
    $stmt = $conn->prepare("INSERT INTO item_adjustment (date, item_code, item_name, quantity, status, task, remark) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssdsss", $date, $item_code, $item_name, $quantity, $status, $task, $remark);

    // Loop through each row of data and execute the prepared statement
    for ($i = 0; $i < count($item_codes); $i++) {
        $item_code = $item_codes[$i];
        $item_name = $item_names[$i];
        $quantity = $quantities[$i];
        $status = $statuses[$i];
        $task = $tasks[$i];
        $remark = $remarks[$i];

        // Execute insertion for each row
        if (!$stmt->execute()) {
            echo "<script>alert('Error: Could not save item adjustment for item code $item_code.');</script>";
        }
    }

    // Close the statement and redirect with success message
    $stmt->close();
    $conn->close();

    echo "<script>alert('Item adjustments saved successfully!');</script>";
    echo "<script>window.location.href = 'list_item_adjustments.php';</script>";
}
?>
