<?php
require_once 'db_connection.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $cus_rtn_id = $_POST['cus_rtn_id'];
    $invoice_no = $_POST['invoice_no'];
    $customer_name = $_POST['customer_name'];
    $date = $_POST['date'];
    $salesman = $_POST['salesman'];
    $rtn_value = $_POST['rtn_value'];

    // Update customer_return_master table
    $stmt = $conn->prepare("UPDATE customer_return_master SET invoice_no = ?, customer_name = ?, date = ?, salesman = ?, rtn_value = ? WHERE cus_rtn_id = ?");
    $stmt->bind_param("ssssdi", $invoice_no, $customer_name, $date, $salesman, $rtn_value, $cus_rtn_id);
    $stmt->execute();

    // Delete old customer_details data
    $stmt = $conn->prepare("DELETE FROM customer_details WHERE cus_rtn_id = ?");
    $stmt->bind_param("i", $cus_rtn_id);
    $stmt->execute();

    // Insert updated customer_details data
    foreach ($_POST['item_code'] as $index => $item_code) {
        $item_name = $_POST['item_name'][$index];
        $quantity = $_POST['quantity'][$index];
        $amount = $_POST['amount'][$index];
        $subtotal = $_POST['subtotal'][$index];
        $remark = $_POST['remark'][$index];

        $stmt = $conn->prepare("INSERT INTO customer_details (cus_rtn_id, item_code, item_name, quantity, amount, subtotal, remark) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("issidss", $cus_rtn_id, $item_code, $item_name, $quantity, $amount, $subtotal, $remark);
        $stmt->execute();
    }

    // Redirect to the list page after update
    header("Location: list_cus_rtn.php");
    exit();
} else {
    die("Invalid request.");
}
?>
