<?php
require_once 'db_connection.php';

// Error Reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Retrieve the form inputs
    $id = $_POST['id'];
    $name = $_POST['name'];   
    $date = $_POST['date'];
    $fiton_date = $_POST['fiton_date'];
    $final_fiton_date = $_POST['final_fiton_date'];
    $job_action = $_POST['job_action'];
    $d_date = $_POST['d_date'];

    // Update the job card details
    $sql = "UPDATE job_cards SET name=?, date=?, fiton_date=?, final_fiton_date=?, job_action=?, d_date=? WHERE id=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ssssssi", $name, $date, $fiton_date, $final_fiton_date, $job_action, $d_date, $id);
    $stmt->execute();

    // Delete existing job items and payments for the job card
    $sql_delete_items = "DELETE FROM job_items WHERE job_card_id=?";
    $stmt_delete_items = $conn->prepare($sql_delete_items);
    $stmt_delete_items->bind_param("i", $id);
    $stmt_delete_items->execute();

    $sql_delete_payments = "DELETE FROM job_payments WHERE job_card_id=?";
    $stmt_delete_payments = $conn->prepare($sql_delete_payments);
    $stmt_delete_payments->bind_param("i", $id);
    $stmt_delete_payments->execute();

    // Insert updated job items
    $items = $_POST['items'];
    foreach ($items as $item) {
        $item_code = $item['item_code'];
        $item_name = $item['item_name'];
        $quantity = $item['quantity'];
        $payment = $item['payment'];

        $sql_insert_item = "INSERT INTO job_items (job_card_id, item_code, item_name, quantity, payment) VALUES (?, ?, ?, ?, ?)";
        $stmt_insert_item = $conn->prepare($sql_insert_item);
        $stmt_insert_item->bind_param("issid", $id, $item_code, $item_name, $quantity, $payment);
        $stmt_insert_item->execute();
    }

    // Insert updated job payments
    $payments = $_POST['payments'];
    $totalPaid = 0;
    foreach ($payments as $payment) {
        $payment_date = $payment['date'];
        $payment_type = $payment['payment_type'];
        $payment_amount = $payment['payment_amount'];
        $payment_by = $payment['payment_by'];

        $totalPaid += $payment_amount;

        $sql_insert_payment = "INSERT INTO job_payments (job_card_id, date, payment_type, payment_amount, payment_by) VALUES (?, ?, ?, ?, ?)";
        $stmt_insert_payment = $conn->prepare($sql_insert_payment);
        $stmt_insert_payment->bind_param("issds", $id, $payment_date, $payment_type, $payment_amount, $payment_by);
        $stmt_insert_payment->execute();
    }

    // Calculate and update the balance
    $totalPayment = $_POST['payment'];
    $balance = $totalPayment - $totalPaid;

    $sql_update_balance = "UPDATE job_cards SET balance=? WHERE id=?";
    $stmt_update_balance = $conn->prepare($sql_update_balance);
    $stmt_update_balance->bind_param("di", $balance, $id);
    $stmt_update_balance->execute();

    // Redirect to the job card list or detail page after update
    header("Location: job_card_list.php"); // Adjust this to the appropriate page
    exit();
}
?>
