<?php
require_once 'db_connection.php';

// Check if form data is posted
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Retrieve rent_no
    $rent_no = $_POST['rent_no'];

    // Sanitize input data
    $salesman = $_POST['salesman'];
    $name = $_POST['name'];
    $date = $_POST['date'];
    $hand_over = $_POST['hand_over'];
    $total_amount = $_POST['total_amount'];
    $discount = $_POST['discount'];
    $balance = $_POST['balance'];
    $fiton_date = $_POST['fiton_date'];
    $rent_action = $_POST['rent_action'];
    $booking_date = $_POST['booking_date']; // Add booking_date

    // Update rent_master table
    $query_master = "UPDATE rent_master SET 
                        salesman = ?, 
                        name = ?, 
                        date = ?, 
                        hand_over = ?, 
                        total_amount = ?, 
                        discount = ?, 
                        balance = ?,
                        fiton_date = ?, 
                        rent_action = ?,
                        booking_date = ?  -- Add booking_date to the query
                     WHERE rent_no = ?";
    $stmt_master = $conn->prepare($query_master);
    $stmt_master->bind_param('ssssddssssi', $salesman, $name, $date, $hand_over, $total_amount, $discount, $balance, $fiton_date, $rent_action, $booking_date, $rent_no); // Add booking_date to bind_param

    if ($stmt_master->execute()) {
        // Delete existing rent details for the rent_no (optional, depends on how you handle updates)
        $delete_details_query = "DELETE FROM rent_details WHERE rent_no = ?";
        $stmt_delete_details = $conn->prepare($delete_details_query);
        $stmt_delete_details->bind_param('i', $rent_no);
        $stmt_delete_details->execute();

        // Insert updated rent details
        if (isset($_POST['items']) && count($_POST['items']) > 0) {
            foreach ($_POST['items'] as $item) {
                $item_code = $item['item_code'];
                $item_name = $item['item_name'];
                $quantity = $item['quantity'];
                $price = $item['price'];
                $status = $item['status'];
                $item_date = $item['date'];

                $insert_details_query = "INSERT INTO rent_details (rent_no, item_code, item_name, quantity, price, status, date) 
                                         VALUES (?, ?, ?, ?, ?, ?, ?)";
                $stmt_insert_details = $conn->prepare($insert_details_query);
                $stmt_insert_details->bind_param('issdiss', $rent_no, $item_code, $item_name, $quantity, $price, $status, $item_date);
                $stmt_insert_details->execute();
            }
        }

        // Delete existing rent payments for the rent_no (optional, depends on how you handle updates)
        $delete_payment_query = "DELETE FROM rent_payment WHERE rent_no = ?";
        $stmt_delete_payment = $conn->prepare($delete_payment_query);
        $stmt_delete_payment->bind_param('i', $rent_no);
        $stmt_delete_payment->execute();

        // Insert updated rent payments
        if (isset($_POST['payments']) && count($_POST['payments']) > 0) {
            foreach ($_POST['payments'] as $payment) {
                $payment_date = $payment['date'];
                $payment_amount = $payment['payment'];
                $payment_type = $payment['payment_type'];
                $remark = $payment['remark'];

                $insert_payment_query = "INSERT INTO rent_payment (rent_no, date, payment, payment_type, remark) 
                                         VALUES (?, ?, ?, ?, ?)";
                $stmt_insert_payment = $conn->prepare($insert_payment_query);
                $stmt_insert_payment->bind_param('isiss', $rent_no, $payment_date, $payment_amount, $payment_type, $remark);
                $stmt_insert_payment->execute();
            }
        }

        // Redirect to a success page or back to the edit page
        header("Location: list_rent.php");
        exit;
    } else {
        // Handle errors (e.g., failed update)
        echo "Error updating rent record: " . $conn->error;
    }
} else {
    echo "Invalid request method.";
}
?>