<?php
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

$role = $_SESSION['role'];

if ($role !== 'admin' && $role !== 'user') {
    echo "Access denied.";
    exit();
}

include 'db_connection.php';

// Fetch categories from the database
$sql = "SELECT category_name FROM category_profile";
$result = $conn->query($sql);
$categories = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $categories[] = $row['category_name'];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Create Item Profile</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2>Create Item Profile</h2>
    <form action="process_create_item_profile.php" method="post">
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_code">Item Code:</label>
                <input type="text" id="item_code" name="item_code" class="form-control" required>
            </div>
            <div class="form-group col-md-6">
                <label for="item_name">Item Name:</label>
                <input type="text" id="item_name" name="item_name" class="form-control" required>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_price">Item Price:</label>
                <input type="number" id="item_price" name="item_price" class="form-control" step="0.01" required>
            </div>
            <div class="form-group col-md-6">
                <label for="item_description">Item Description:</label>
                <textarea id="item_description" name="item_description" class="form-control"></textarea>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_category">Item Category:</label>
                <select id="item_category" name="item_category" class="form-control" required>
                    <option value="">Select a Category</option>
                    <?php foreach ($categories as $category): ?>
                        <option value="<?php echo htmlspecialchars($category); ?>"><?php echo htmlspecialchars($category); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="item_type">Item Type:</label>
                <select id="item_type" name="item_type" class="form-control" required>
                    <option value="Raw Material">Raw Material</option>
                    <option value="Rent Item">Rent Item</option>
                    <option value="Sell Item">Sell Item</option>
                </select>
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="create_date">Create Date:</label>
                <input type="datetime-local" id="create_date" name="create_date" class="form-control" required>
            </div>

            <div class="form-group col-md-6">
                <label for="unit_ok">Unit:</label>
                <select id="unit_ok" name="unit_ok" class="form-control" required>
                    <option value="Each">Each</option>
                    <option value="Yards">Yards</option>
                    <option value="M">M</option>
                    <option value="KG">KG</option>
                </select>
            </div>
        </div>

        <!-- New Colour Field -->
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="item_colour">Colour:</label>
                <select id="item_colour" name="item_colour" class="form-control" required>
                    <option value="-----">-----</option>
                    <option value="Beige">Beige</option>
                    <option value="Black">Black</option>
                    <option value="Check ash">Check ash</option>
                    <option value="Check blue">Check blue</option>
                    <option value="Check grey">Check grey</option>
                    <option value="Check lite ash">Check lite ash</option>
                    <option value="Check meroon">Check meroon</option>
                    <option value="Chocolate brown">Chocolate brown</option>
                    <option value="Cotton ash">Cotton ash</option>
                    <option value="Cotton ash brown">Cotton ash brown</option>
                    <option value="Cotton beige">Cotton beige</option>
                    <option value="Cotton blue">Cotton blue</option>
                    <option value="Cotton dark brown">Cotton dark brown</option>
                    <option value="Dark ash">Dark ash</option>
                    <option value="Dark brown">Dark brown</option>
                    <option value="Dark green">Dark green</option>
                    <option value="Floral black">Floral black</option>
                    <option value="Floral green">Floral green</option>
                    <option value="Floral orange">Floral orange</option>
                    <option value="Grey">Grey</option>
                    <option value="Lavendra ash">Lavendra ash</option>
                    <option value="Lavendra blue">Lavendra blue</option>
                    <option value="Lite green">Lite green</option>
                    <option value="Lite pink">Lite pink</option>
                    <option value="Meroon">Meroon</option>
                    <option value="Mix lavendra ash">Mix lavendra ash</option>
                    <option value="Moose green">Moose green</option>
                    <option value="Navy blue">Navy blue</option>
                    <option value="New dark blue">New dark blue</option>
                    <option value="Pink">Pink</option>
                    <option value="purple">purple</option>
                    <option value="Royal blue">Royal blue</option>
                    <option value="Shine ash">Shine ash</option>
                    <option value="Shine beige">Shine beige</option>
                    <option value="Shine black">Shine black</option>
                    <option value="Shine blue">Shine blue</option>
                    <option value="Shine meroon">Shine meroon</option>
                    <option value="Shine pencil blue">Shine pencil blue</option>
                    <option value="Sky blue">Sky blue</option>
    


                  </select>
            </div>

            <!-- New Size Field -->
            <div class="form-group col-md-6">
                <label for="item_size">Size:</label>
                <select id="item_size" name="item_size" class="form-control" required>
                    <option value="----">----</option>
                    
<option value="22">22</option>
<option value="24">24</option>
<option value="26">26</option>
<option value="28">28</option>
<option value="30">30</option>
<option value="32">32</option>
<option value="34">34</option>
<option value="36">36</option>
<option value="38">38</option>
<option value="40">40</option>
<option value="42">42</option>
<option value="44">44</option>
<option value="46">46</option>
<option value="48">48</option>

                </select>
            </div>
        </div>

        <button type="submit" class="btn btn-success">Create Item Profile</button>
    </form>
</div>
</body>
</html>

<?php
$conn->close();
?>
