<?php
require_once 'db_connection_pdo.php';

// Get search parameters from URL
$searchJobCardId = isset($_GET['job_card_id']) ? trim($_GET['job_card_id']) : '';
$searchCustomerName = isset($_GET['customer_name']) ? trim($_GET['customer_name']) : '';
$searchStartDate = isset($_GET['start_date']) ? trim($_GET['start_date']) : '';
$searchEndDate = isset($_GET['end_date']) ? trim($_GET['end_date']) : '';
$searchBalanceZero = isset($_GET['balance_zero']) ? trim($_GET['balance_zero']) : '';
$searchJobAction = isset($_GET['job_action']) ? trim($_GET['job_action']) : '';

// Build SQL query for pending jobs
$sql = "
SELECT 
    jc.id AS Job_Card_ID,
    jc.name AS Customer_Name,
    jc.date AS Job_Date,
    jc.fiton_date AS Fiton_Date,
    jc.final_fiton_date AS Final_Fiton_Date,
     jc.d_date AS d_date,
    jc.total_payment AS Total_Payment,
    jc.balance AS Balance,
    GROUP_CONCAT(ji.item_name SEPARATOR ', ') AS Items,
    SUM(jp.payment_amount) AS Total_Paid,
    jc.total_payment - IFNULL(SUM(jp.payment_amount), 0) AS Remaining_Balance
FROM 
    job_cards jc
LEFT JOIN 
    job_items ji ON jc.id = ji.job_card_id
LEFT JOIN 
    job_payments jp ON jc.id = jp.job_card_id
WHERE 
    1=1
";

// Add filtering conditions
if (!empty($searchJobCardId)) {
    $sql .= " AND jc.id = :job_card_id";
}
if (!empty($searchCustomerName)) {
    $sql .= " AND jc.name LIKE :customer_name";
}
if (!empty($searchStartDate)) {
    $sql .= " AND (
                (jc.date >= :start_date) OR
                (jc.fiton_date >= :start_date) OR
                (jc.final_fiton_date >= :start_date)
             )";
}
if (!empty($searchEndDate)) {
    $sql .= " AND (
                (jc.date <= :end_date) OR
                (jc.fiton_date <= :end_date) OR
                (jc.final_fiton_date <= :end_date)
             )";
}
if ($searchBalanceZero === '1') {
    $sql .= " AND jc.balance = 0";
} elseif ($searchBalanceZero === '0') {
    $sql .= " AND jc.balance > 0";
}
if (!empty($searchJobAction)) {
    $sql .= " AND jc.job_action = :job_action";
}

$sql .= " GROUP BY jc.id ORDER BY jc.date DESC";

// Prepare SQL statement
$stmt = $pdo->prepare($sql);

// Bind parameters based on input
if (!empty($searchJobCardId)) {
    $stmt->bindValue(':job_card_id', $searchJobCardId, PDO::PARAM_INT);
}
if (!empty($searchCustomerName)) {
    $stmt->bindValue(':customer_name', "%$searchCustomerName%", PDO::PARAM_STR);
}
if (!empty($searchStartDate)) {
    $stmt->bindValue(':start_date', $searchStartDate, PDO::PARAM_STR);
}
if (!empty($searchEndDate)) {
    $stmt->bindValue(':end_date', $searchEndDate, PDO::PARAM_STR);
}
if (!empty($searchJobAction)) {
    $stmt->bindValue(':job_action', $searchJobAction, PDO::PARAM_STR);
}

// Execute query
$stmt->execute();
$pendingJobs = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pending Job Report</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<?php require_once 'menu.html';?>

<div class="container mt-5">
    <h1 class="mb-4">Pending Job Report</h1>

    <!-- Search Form -->
    <form method="GET" action="" class="form-inline mb-4">
        <div class="form-group mr-1">
          
            <input type="text" name="job_card_id" id="job_card_id" class="form-control" placeholder="Job Card ID" value="<?php echo htmlspecialchars($searchJobCardId); ?>">
        </div>
        <div class="form-group mr-1">
           
            <input type="text" name="customer_name" id="customer_name" class="form-control" placeholder="Customer Name" value="<?php echo htmlspecialchars($searchCustomerName); ?>">
        </div>
        <div class="form-group mr-1">
          
            <input type="date" name="start_date" id="start_date" class="form-control" value="<?php echo htmlspecialchars($searchStartDate); ?>">
        </div>
        <div class="form-group mr-1">
           
            <input type="date" name="end_date" id="end_date" class="form-control" value="<?php echo htmlspecialchars($searchEndDate); ?>">
        </div>
        <div class="form-group mr-1">
           
            <select name="balance_zero" id="balance_zero" class="form-control">
                <option value="" <?php echo ($searchBalanceZero === '') ? 'selected' : ''; ?>>All</option>
                <option value="1" <?php echo ($searchBalanceZero === '1') ? 'selected' : ''; ?>>Zero</option>
                <option value="0" <?php echo ($searchBalanceZero === '0') ? 'selected' : ''; ?>>Not Zero</option>
            </select>
        </div>
        <div class="form-group mr-1">
            <label for="job_action" class="mr-2">Job Action:</label>
            <select name="job_action" id="job_action" class="form-control">
                <option value="" <?php echo ($searchJobAction === '') ? 'selected' : ''; ?>>All</option>
                <option value="Pending" <?php echo ($searchJobAction === 'Pending') ? 'selected' : ''; ?>>Pending</option>
                <option value="Complete" <?php echo ($searchJobAction === 'Complete') ? 'selected' : ''; ?>>Complete</option>
                <option value="Delivered" <?php echo ($searchJobAction === 'Delivered') ? 'selected' : ''; ?>>Delivered</option>
            </select>
        </div>
        <button type="submit" class="btn btn-primary">Search</button>
        <a href="pending_jobs_report.php" class="btn btn-secondary ml-3">Clear</a>
    </form>

    <!-- Report Table -->
    <table class="table table-striped">
        <thead class="thead-dark">
            <tr>
                <th>Job ID</th>
                <th>Customer Name</th>
                <th>Job Date</th>
                <th>Fiton Date</th>
                <th>Final Date</th>
                <th>Delivery Date</th>
                <th>Items</th>
                <th>Remaining Balance</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($pendingJobs) > 0): ?>
                <?php foreach ($pendingJobs as $job): ?>
                    <tr>
                        <td>
                            <a href="job_card_details.php?job_card_id=<?php echo htmlspecialchars($job['Job_Card_ID']); ?>">
                                <?php echo htmlspecialchars($job['Job_Card_ID']); ?>
                            </a>
                        </td>
                        <td><?php echo htmlspecialchars($job['Customer_Name']); ?></td>
                        <td><?php echo htmlspecialchars($job['Job_Date']); ?></td>
                        <td><?php echo htmlspecialchars($job['Fiton_Date']); ?></td>
                        <td><?php echo htmlspecialchars($job['Final_Fiton_Date']); ?></td>
                        <td><?php echo htmlspecialchars($job['d_date']); ?></td>
                        <td><?php echo htmlspecialchars($job['Items']); ?></td>
                        <td><?php echo htmlspecialchars(number_format($job['Balance'], 2)); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="8" class="text-center">No pending jobs found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
</body>
</html>