<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rent List Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f8f9fa;
            padding: 20px;
        }
        .table thead th {
            background-color: #007bff;
            color: white;
        }
        @media print {
            body {
                background: none;
            }
            .no-print {
                display: none;
            }
            .table {
                border-collapse: collapse;
                width: 100%;
            }
            .table th, .table td {
                border: 1px solid #000;
                padding: 8px;
            }
        }
    </style>
</head>
<body>
<?php require_once 'menu.html';?>
    
        <h1 class="text-center mb-4">List of Rents</h1>
        <div class="no-print mb-3">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <label for="rent_no" class="form-label">Rent No</label>
                    <input type="text" name="rent_no" id="rent_no" class="form-control" value="<?php echo $_GET['rent_no'] ?? ''; ?>">
                </div>
                <div class="col-md-3">
                    <label for="name" class="form-label">Customer Name</label>
                    <input type="text" name="name" id="name" class="form-control" value="<?php echo $_GET['name'] ?? ''; ?>">
                </div>
                <div class="col-md-3">
                    <label for="date_from" class="form-label">Date From</label>
                    <input type="date" name="date_from" id="date_from" class="form-control" value="<?php echo $_GET['date_from'] ?? ''; ?>">
                </div>
                <div class="col-md-3">
                    <label for="date_to" class="form-label">Date To</label>
                    <input type="date" name="date_to" id="date_to" class="form-control" value="<?php echo $_GET['date_to'] ?? ''; ?>">
                </div>
                <div class="col-md-3">
                    <label for="rent_action" class="form-label">Rent Action</label>
                    <select name="rent_action" id="rent_action" class="form-select">
                        <option value="">All</option>
                        <option value="Pending" <?php echo (isset($_GET['rent_action']) && $_GET['rent_action'] === 'Pending') ? 'selected' : ''; ?>>Pending</option>
                        <option value="Complete" <?php echo (isset($_GET['rent_action']) && $_GET['rent_action'] === 'Complete') ? 'selected' : ''; ?>>Complete</option>
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary me-2">Filter</button>
                    <a href="rent_details_report.php" class="btn btn-secondary">Clear</a>
                    <button type="button" onclick="window.print()" class="btn btn-success ms-2">Print</button>
                </div>
            </form>
        </div>
        <div class="card">
            <div class="card-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Rent No</th>
                            <th>Customer Name</th>
                            <th>Items</th>
                            <th>Date</th>
                            <th>Booking Date</th>
                            <th>Fiton Date</th>
                            <th>Hand Over Date</th>
                            <th>Total</th>
                            <th>Balance</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        include 'db_connection.php';

                        $conditions = [];
                        if (!empty($_GET['rent_no'])) {
                            $rent_no = $conn->real_escape_string($_GET['rent_no']);
                            $conditions[] = "rent_no = '$rent_no'";
                        }
                        if (!empty($_GET['name'])) {
                            $name = $conn->real_escape_string($_GET['name']);
                            $conditions[] = "name LIKE '%$name%'";
                        }
                        if (!empty($_GET['date_from']) && !empty($_GET['date_to'])) {
                            $date_from = $conn->real_escape_string($_GET['date_from']);
                            $date_to = $conn->real_escape_string($_GET['date_to']);
                            $conditions[] = "date BETWEEN '$date_from' AND '$date_to'";
                        }
                        if (!empty($_GET['rent_action'])) {
                            $rent_action = $conn->real_escape_string($_GET['rent_action']);
                            $conditions[] = "rent_action = '$rent_action'";
                        }

                        $where = !empty($conditions) ? 'WHERE ' . implode(' AND ', $conditions) : '';

                        $sql = "SELECT * FROM rent_master $where";
                        $result = $conn->query($sql);

                        $total_sum = 0;
                        $balance_sum = 0;

                        if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                $total_sum += $row['total_amount'];
                                $balance_sum += $row['balance'];

                                echo "<tr>";
                                echo "<td><a href='rent_report_page.php?rent_no=" . $row['rent_no'] . "'>" . $row['rent_no'] . "</a></td>";
                                echo "<td>" . $row['name'] . "</td>";

                                $rent_no = $row['rent_no'];
                                $items_sql = "SELECT item_name, quantity, price FROM rent_details WHERE rent_no = $rent_no";
                                $items_result = $conn->query($items_sql);

                                if ($items_result->num_rows > 0) {
                                    $items = [];
                                    while ($item_row = $items_result->fetch_assoc()) {
                                        $items[] = $item_row['item_name'] . " (Qty: " . $item_row['quantity'] . ", Rs." . number_format($item_row['price'], 2) . ")";
                                    }
                                    echo "<td>" . implode('<br>', $items) . "</td>";
                                } else {
                                    echo "<td>No items</td>";
                                }

                                echo "<td>" . $row['date'] . "</td>";
                                echo "<td>" . $row['booking_date'] . "</td>";
                                echo "<td>" . $row['fiton_date'] . "</td>";
                                echo "<td>" . $row['hand_over'] . "</td>";
                                echo "<td>Rs." . number_format($row['total_amount'], 2) . "</td>";
                                echo "<td>Rs." . number_format($row['balance'], 2) . "</td>";
                                echo "<td>" . $row['rent_action'] . "</td>";
                                echo "</tr>";
                            }
                        } else {
                            echo "<tr><td colspan='10' class='text-center'>No records found</td></tr>";
                        }

                        $conn->close();
                        ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="7" class="text-end">Total</th>
                            <th>Rs. <?php echo number_format($total_sum, 2); ?></th>
                            <th>Rs. <?php echo number_format($balance_sum, 2); ?></th>
                            <th></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
