<?php
require_once 'db_connection.php';

if (isset($_GET['id'])) {
    $id = $_GET['id'];
    $sql = "SELECT * FROM job_cards WHERE id = $id";
    $result = $conn->query($sql);
    $job_card = $result->fetch_assoc();
    
    $sql_items = "SELECT * FROM job_items WHERE job_card_id = $id";
    $items_result = $conn->query($sql_items);
    
    $sql_payments = "SELECT * FROM job_payments WHERE job_card_id = $id";
    $payments_result = $conn->query($sql_payments);
} else {
    die("Job Card ID is missing.");
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <title>Customer Order Receipt</title>
    <style>
        /* Set the width to 3 inches for printing */
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #f5f5f5;
            width: 100%;
            max-width: 3in; /* Set the max-width to 3 inches */
        }

        .invoice-container {
            width: 100%;
            padding: 5px; /* Reduce padding */
            background-color: #fff;
        }

        .invoice-header {
            text-align: center;
            margin-bottom: 10px;
        }

        .invoice-header img {
            max-width: 100px;
            height: auto;
        }

        .invoice-title {
            text-align: center;
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 10px;
            border-bottom: 1px solid #000;
            padding-bottom: 5px;
        }

        .invoice-info, .payment-details, .notes-section {
            font-size: 10px;
            margin-bottom: 10px;
        }

        .invoice-info p, .payment-details p {
            margin: 3px 0;
        }

        .item-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }

        .item-table th, .item-table td {
            padding: 5px;
            border: 0px solid #000;
            text-align: left;
            font-size: 10px;
        }

        .item-table th {
            background-color: #f8f9fa;
        }

        .totals-section {
            width: 100%;
            font-size: 10px;
            margin-bottom: 0px;
        }

        .totals-section th, .totals-section td {
            padding: 5px;
            text-align: right;
        }

            .payment-section, .notes-section {
            margin-top: 0px;
            border: 0px solid #000;
            padding: 0px;
        }

        .footer-section {
            text-align: center;
            font-size: 10px;
            margin-top: 0px;
        }

        .footer-section p {
            margin: 5px 0;
        }
        .totals-section th, .totals-section td {
            padding: 5px;
            text-align: left;
            border: 0px solid #000;
        }
        .notes-section {
            font-size: 10px;
            margin-top: 0px;
        }
        .notes-section h5 {
            font-size: 10px;
            margin-bottom: 5px;
        }
        .notes-section p {
            margin: 0;
            padding: 5px;
            border: 1px solid #000;
            text-align: center;
        }
        .footer-section {
            text-align: center;
            font-size: 10px;
            margin-top: 0px;
            color: #000;
        }

        @media print {
            body, .invoice-container {
                width: 100%;
                max-width: 3in;
            }

            .btn-print {
                display: none;
            }
        }
    </style>
</head>
<body>
<div class="invoice-container">
     <!-- Header Section -->
     <div class="invoice-header">
        <img src="logo.png" alt="Company Logo">
    </div>

      <!-- Invoice Title -->
      <div class="invoice-title">
      invoice for Customer Order
    </div>
   <!-- Invoice Information -->
 <div class="invoice-info">
        <p><strong>Job ID:</strong> <?php echo $job_card['id']; ?></p>
        <p><strong>Customer Name:</strong> <?php echo $job_card['name']; ?></p>
        <p><strong>Date:</strong> <?php echo $job_card['date']; ?></p>
        <p><strong>Fit-on Date:</strong> <?php echo $job_card['fiton_date']; ?></p>
        <p><strong>Final Fit-on Date:</strong> <?php echo $job_card['final_fiton_date']; ?></p>
        <p><strong>Job Action:</strong> <?php echo $job_card['job_action']; ?></p>
    </div>


    <table class="item-table">
        <thead>
            <tr>
                <th>Description</th>
                <th>Price</th>
                <th>Qty</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $total_amount = 0;
            while ($item = $items_result->fetch_assoc()): 
                $item_total = $item['payment']; // assuming payment field is per item
                $total_amount += $item_total;
            ?>
            <tr>
            <tr><td><?php echo $item['item_name']; ?></td></tr>
            <td></td>
                <td><?php echo number_format($item['payment'], 2); ?></td>
                <td><?php echo number_format($item['quantity']); ?></td> <!-- Adjust this if you track quantity separately -->
                <td><?php echo number_format($item_total, 2); ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
    <hr>
    <table class="totals-section">
        <tr>
            <th>Amount:</th>
            <td><?php echo number_format($total_amount, 2); ?></td>
        </tr>
        <tr class="totals-row">
            <th>Total Amount:</th>
            <td><?php echo number_format($job_card['total_payment'], 2); ?></td>
        </tr>
        <tr class="totals-row">
            <th>Balance:</th>
            <td><?php echo number_format($job_card['balance'], 2); ?></td>
        </tr>
    </table>
    <hr>
    <div class="payment-section">
   
        <h5>Payment Details</h5>
        <table class="item-table">
        <thead>
            <tr>
                <th>Date</th>
                <th>Type</th>
                <th>Payment</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($payment = $payments_result->fetch_assoc()): ?>
            <tr>
                <td><?php echo $payment['date']; ?></td>
                <td><?php echo $payment['payment_type']; ?></td>
                <td><?php echo number_format($payment['payment_amount'], 2); ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
         </table>
    </div>
    <div class="notes-section">
        <h5>Special Notes and Instructions</h5>
        <p><?php echo "Opening Hours - 8.00 AM to 6.00 PM"?></p>
        
    </div>
    <div class="footer-section">
        <p>NO 255, Colombo Road, Peradeniya</p>
        <p><i style="font-size:15px" class="fa">&#xf095;</i> &emsp14; 081 3134005 &emsp14; <i style="font-size:15px" class="fa">&#xf232;</i>  076 1499934</p>
       
        <p><i style="font-size:15px" class="fa">&#xf0e0;</i>&emsp14; info@janakatailors.lk&emsp14;<i style="font-size:15px" class="fa">&#xf09a;</i> &emsp14;janaka Tailors</p>
    </div>
</div>
</body>
</html>

<?php $conn->close(); ?>
