<?php
require_once 'db_connection.php';

// Get the customer return ID from the URL
if (isset($_GET['cus_rtn_id'])) {
    $cus_rtn_id = $_GET['cus_rtn_id'];

    // Delete the details section records first
    $detailsQuery = $conn->prepare("DELETE FROM customer_return_details WHERE cus_rtn_id = ?");
    $detailsQuery->bind_param("i", $cus_rtn_id);
    $detailsQuery->execute();

    // Delete the master record
    $masterQuery = $conn->prepare("DELETE FROM customer_return_master WHERE cus_rtn_id = ?");
    $masterQuery->bind_param("i", $cus_rtn_id);
    $masterQuery->execute();

    if ($masterQuery->affected_rows > 0) {
        echo "<script>alert('Customer return record deleted successfully.'); window.location.href='list_cus_rtn.php';</script>";
    } else {
        echo "<script>alert('Error deleting record.'); window.location.href='list_cus_rtn.php';</script>";
    }
} else {
    echo "Invalid request.";
    exit;
}

// Close the database connection
$conn->close();
?>
