<?php
require_once 'db_connection.php';

// Check if rent_no is provided in the query string
if (isset($_GET['rent_no'])) {
    $rent_no = $_GET['rent_no'];

    // Fetch rent master details
    $sql_master = "SELECT * FROM rent_master WHERE rent_no = ?";
    $stmt_master = $conn->prepare($sql_master);
    $stmt_master->bind_param("i", $rent_no);
    $stmt_master->execute();
    $result_master = $stmt_master->get_result();
    $rent_master = $result_master->fetch_assoc();

    // Fetch rent details
    $sql_details = "SELECT * FROM rent_details WHERE rent_no = ?";
    $stmt_details = $conn->prepare($sql_details);
    $stmt_details->bind_param("i", $rent_no);
    $stmt_details->execute();
    $result_details = $stmt_details->get_result();

    // Fetch rent payments
    $sql_payment = "SELECT * FROM rent_payment WHERE rent_no = ?";
    $stmt_payment = $conn->prepare($sql_payment);
    $stmt_payment->bind_param("i", $rent_no);
    $stmt_payment->execute();
    $result_payment = $stmt_payment->get_result();
} else {
    die("No rent_no provided.");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Rent</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <style>
        .form-group { margin-bottom: 15px; }
        .section-header { background-color: #f8f9fa; padding: 10px; margin-bottom: 20px; border: 1px solid #dee2e6; border-radius: 5px; }
        .table th, .table td { vertical-align: middle; }
    </style>

<!-- Inside your <head> tag or just before the closing </body> tag -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>

<script>
$(document).ready(function() {
    // Event listener for item code input field
    $(document).on('blur', '.item_code', function() {
        var $row = $(this).closest('tr');
        var item_code = $(this).val();

        if (item_code !== '') {
            // AJAX request to fetch item details
            $.ajax({
                url: 'get_item_details.php',
                type: 'POST',
                data: {item_code: item_code},
                dataType: 'json',
                success: function(response) {
                    if (response.item_name) {
                        $row.find('.item_name').val(response.item_name);
                        $row.find('.price').val(response.item_price);

                        // Automatically calculate the subtotal
                        var quantity = $row.find('.quantity').val();
                        var subtotal = parseFloat(quantity) * parseFloat(response.item_price);
                        $row.find('.subtotal').val(subtotal.toFixed(2));
                    } else {
                        alert('Item not found!');
                        $row.find('.item_name').val('');
                        $row.find('.price').val('');
                        $row.find('.subtotal').val('');
                    }
                },
                error: function() {
                    alert('Error retrieving item details.');
                }
            });
        }
    });

    // Event listener to calculate subtotal when quantity is changed
    $(document).on('change', '.quantity', function() {
        var $row = $(this).closest('tr');
        var price = parseFloat($row.find('.price').val());
        var quantity = parseFloat($(this).val());

        var subtotal = quantity * price;
        $row.find('.subtotal').val(subtotal.toFixed(2));
    });
});
</script>




</head>
<body>
<?php require_once 'menu.html';?>
<div class="container mt-5">
    <h2 class="text-center">Edit Rent</h2>
    <form id="edit_rent_form" method="POST" action="update_edit_rent.php">
        <input type="hidden" name="rent_no" value="<?php echo $rent_no; ?>">
        
        <!-- Rent Master Section -->
        <div class="section-header">
            <h4>Rent Master</h4>
        </div>
        <div class="form-row">
            <div class="form-group col-md-3">
                <label for="salesman">Salesman</label>
                <select class="form-control" id="salesman" name="salesman" required>
                    <option value="">Select Salesman</option>
                    <option value="nimal" <?php if ($rent_master['salesman'] == 'nimal') echo 'selected'; ?>>Nimal</option>
                    <option value="kamal" <?php if ($rent_master['salesman'] == 'kamal') echo 'selected'; ?>>Kamal</option>
                    <option value="pranith" <?php if ($rent_master['salesman'] == 'pranith') echo 'selected'; ?>>Pranith</option>
                </select>
            </div>
            <div class="form-group col-md-3">
                <label for="name">Name</label>
                <input type="text" class="form-control" id="name" name="name" value="<?php echo $rent_master['name']; ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label for="address">Address</label>
                <input type="text" class="form-control" id="address" name="address" value="<?php echo $rent_master['address']; ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label for="status">Status</label>
                <select class="form-control" id="status" name="status" required>
                    <option value="Rent" <?php if ($rent_master['status'] == 'Rent') echo 'selected'; ?>>Rent</option>
                    <option value="Return" <?php if ($rent_master['status'] == 'Return') echo 'selected'; ?>>Return</option>
                </select>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-3">
                <label for="nic_no">NIC No</label>
                <input type="text" class="form-control" id="nic_no" name="nic_no" value="<?php echo $rent_master['nic_no']; ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label for="email">Email</label>
                <input type="email" class="form-control" id="email" name="email" value="<?php echo $rent_master['email']; ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label for="date">Date</label>
                <input type="date" class="form-control" id="date" name="date" value="<?php echo $rent_master['date']; ?>" required>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group col-md-3">
                <label for="book_date">Book Date</label>
                <input type="date" class="form-control" id="book_date" name="book_date" value="<?php echo $rent_master['book_date']; ?>" required>
            </div>
            <div class="form-group col-md-3">
                <label for="return_date">Return Date</label>
                <input type="date" class="form-control" id="return_date" name="return_date" value="<?php echo $rent_master['return_date']; ?>" required>
            </div>
        </div>

        <!-- Rent Details Section -->
        <div class="section-header">
            <h4>Rent Details</h4>
        </div>
        <table class="table table-bordered" id="rent_details_table">
            <thead>
                <tr>
                    <th>Item Code</th>
                    <th>Item Name</th>
                    <th>Quantity</th>
                    <th>Price</th>
                    <th>Subtotal</th>
                    <th>Remarks</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $itemIndex = 0;
                while ($row = $result_details->fetch_assoc()) {
                    ?>
                    <tr>
                        <td><input type="text" name="items[<?php echo $itemIndex; ?>][item_code]" class="form-control item_code" value="<?php echo $row['item_code']; ?>" required></td>
                        <td><input type="text" name="items[<?php echo $itemIndex; ?>][item_name]" class="form-control item_name" value="<?php echo $row['item_name']; ?>" readonly required></td>
                        <td><input type="number" name="items[<?php echo $itemIndex; ?>][quantity]" class="form-control quantity" value="<?php echo $row['quantity']; ?>" min="1" required></td>
                        <td><input type="text" name="items[<?php echo $itemIndex; ?>][price]" class="form-control price" value="<?php echo $row['price']; ?>" readonly required></td>
                        <td><input type="text" name="items[<?php echo $itemIndex; ?>][subtotal]" class="form-control subtotal" value="<?php echo $row['subtotal']; ?>" readonly required></td>
                        <td><input type="text" name="items[<?php echo $itemIndex; ?>][remarks]" class="form-control" value="<?php echo $row['remarks']; ?>"></td>
                        <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                    </tr>
                    <?php
                    $itemIndex++;
                }
                ?>
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_row">Add Row</button>

        <!-- Rent Payment Section -->
        <div class="section-header">
            <h4>Rent Payment</h4>
        </div>
        <table class="table table-bordered" id="rent_payment_table">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Payment</th>
                    <th>Payment Type</th>
                    <th>Remark</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $paymentIndex = 0;
                while ($row = $result_payment->fetch_assoc()) {
                    ?>
                    <tr>
                        <td><input type="date" name="payments[<?php echo $paymentIndex; ?>][date]" class="form-control" value="<?php echo $row['date']; ?>" required></td>
                        <td><input type="number" name="payments[<?php echo $paymentIndex; ?>][payment]" class="form-control payment" value="<?php echo $row['payment']; ?>" required></td>
                        <td>
                            <select name="payments[<?php echo $paymentIndex; ?>][payment_type]" class="form-control" required>
                                <option value="Cash" <?php if ($row['payment_type'] == 'Cash') echo 'selected'; ?>>Cash</option>
                                <option value="Credit Card" <?php if ($row['payment_type'] == 'Credit Card') echo 'selected'; ?>>Credit Card</option>
                                <option value="Bank Transfer" <?php if ($row['payment_type'] == 'Bank Transfer') echo 'selected'; ?>>Bank Transfer</option>
                                <option value="Online" <?php if ($row['payment_type'] == 'Online') echo 'selected'; ?>>Online</option>
                            </select>
                        </td>
                        <td><input type="text" name="payments[<?php echo $paymentIndex; ?>][remark]" class="form-control" value="<?php echo $row['remark']; ?>"></td>
                        <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                    </tr>
                    <?php
                    $paymentIndex++;
                }
                ?>
                
            </tbody>
        </table>
        <button type="button" class="btn btn-primary" id="add_payment_row">Add Payment</button>

         <!-- Summary Section -->
         <div class="form-group mt-4">
            <label for="total_amount">Total Amount</label>
            <input type="text" class="form-control" id="total_amount" name="total_amount" value="<?php echo $rent_master['total_amount']; ?>" readonly required>
        </div>
        <div class="form-group mt-4">
            <label for="discount">Discount (%)</label>
            <input type="number" class="form-control" id="discount" name="discount" value="<?php echo $rent_master['discount']; ?>" required>
        </div>
        <div class="form-group mt-4">
            <label for="balance">Balance</label>
            <input type="text" class="form-control" id="balance" name="balance" value="<?php echo $rent_master['balance']; ?>" readonly required>
        </div>


        <div class="mt-4">
            <button type="submit" class="btn btn-success">Update Rent</button>
            <a href="rent_list.php" class="btn btn-secondary">Cancel</a>
        </div>
    </form>
</div>

<script>
      $(document).ready(function () {
    var itemIndex = 1;
    var paymentIndex = 1;

    // Add new row in Rent Details
    $('#add_row').click(function () {
        var newRow = `<tr>
                        <td><input type="text" name="items[${itemIndex}][item_code]" class="form-control item_code" required></td>
                        <td><input type="text" name="items[${itemIndex}][item_name]" class="form-control item_name" readonly required></td>
                        <td><input type="number" name="items[${itemIndex}][quantity]" class="form-control quantity" value="1" min="1" required></td>
                        <td><input type="text" name="items[${itemIndex}][price]" class="form-control price" readonly required></td>
                        <td><input type="text" name="items[${itemIndex}][subtotal]" class="form-control subtotal" readonly required></td>
                        <td><input type="text" name="items[${itemIndex}][remarks]" class="form-control"></td>
                        <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                    </tr>`;
        $('#rent_details_table tbody').append(newRow);
        itemIndex++;
    });

    // Add new row in Rent Payment
    $('#add_payment_row').click(function () {
        var newRow = `<tr>
                        <td><input type="date" name="payments[${paymentIndex}][date]" class="form-control" required></td>
                        <td><input type="text" name="payments[${paymentIndex}][payment]" class="form-control payment" required></td>
                        <td>
                            <select name="payments[${paymentIndex}][payment_type]" class="form-control" required>
                                <option value="cash">Cash</option>
                                <option value="Credit">Credit</option>
                                <option value="Credit Card">Credit Card</option>
                                <option value="Bank Transfer">Bank Transfer</option>
                                <option value="Cheque">Cheque</option>
                            </select>
                        </td>
                        <td><input type="text" name="payments[${paymentIndex}][remark]" class="form-control"></td>
                        <td><button type="button" class="btn btn-danger remove-row">Remove</button></td>
                    </tr>`;
        $('#rent_payment_table tbody').append(newRow);
        paymentIndex++;
        calculateBalance(); // Recalculate balance after adding a new row
    });

    // Remove row
    $(document).on('click', '.remove-row', function () {
        $(this).closest('tr').remove();
        calculateTotalAmount();
        calculateBalance();
    });

    // Autofill item name and price based on item code
    $(document).on('change', '.item_code', function () {
        var $row = $(this).closest('tr');
        var itemCode = $(this).val();

        $.ajax({
            url: 'get_item_details_rent.php',
            type: 'POST',
            data: { item_code: itemCode },
            dataType: 'json',
            success: function (data) {
                $row.find('.item_name').val(data.item_name);
                $row.find('.price').val(data.item_price);
                calculateSubtotal($row);
            }
        });
    });

    // Calculate subtotal when quantity or price changes
    $(document).on('change', '.quantity, .price', function () {
        var $row = $(this).closest('tr');
        calculateSubtotal($row);
    });

    // Calculate total amount when subtotal changes
    function calculateSubtotal($row) {
        var quantity = parseFloat($row.find('.quantity').val());
        var price = parseFloat($row.find('.price').val());
        var subtotal = quantity * price;
        $row.find('.subtotal').val(subtotal.toFixed(2));
        calculateTotalAmount();
    }

    // Calculate total amount
    function calculateTotalAmount() {
        var totalAmount = 0;
        $('.subtotal').each(function () {
            totalAmount += parseFloat($(this).val()) || 0;
        });
        $('#total_amount').val(totalAmount.toFixed(2));
        calculateBalance();
    }

    // Calculate balance when discount or payments change
    $('#discount').on('input', function () {
        calculateBalance();
    });

    $(document).on('input', '.payment', function () {
        calculateBalance();
    });

    function calculateBalance() {
        var totalAmount = parseFloat($('#total_amount').val()) || 0;
        var discount = parseFloat($('#discount').val()) || 0;
        var discountedAmount = totalAmount - (totalAmount * (discount / 100));

        var totalPayments = 0;
        $('.payment').each(function () {
            totalPayments += parseFloat($(this).val()) || 0;
        });

        var balance = discountedAmount - totalPayments;
        $('#balance').val(balance.toFixed(2));
    }
});
</script>
</body>
</html>
