<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GRN List</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
</head>
<body>
<?php require_once 'menu.html'; ?>
<div class="container mt-5">
    <div class="d-flex justify-content-between mb-3">
        <h2 class="text-center">GRN List</h2>
        <a href="create_grn.php" class="btn btn-success">Create New GRN</a>
    </div>
    <div class="mb-3">
        <input type="text" id="searchInput" class="form-control" placeholder="Search by GRN No">
    </div>
    <table class="table table-bordered" id="grnTable">
        <thead>
            <tr>
                <th>GRN No</th>
                <th>Supplier Name</th>
                <th>Date</th>
                <th>Total</th>
                <th>Balance</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
            require_once 'db_connection.php';

            $sql = "SELECT * FROM grn_master ORDER BY grn_no DESC";
            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>{$row['grn_no']}</td>";
                    echo "<td>{$row['supplier_name']}</td>";
                    echo "<td>{$row['date']}</td>";
                    echo "<td>{$row['total']}</td>";
                    echo "<td>{$row['balance']}</td>";
                    echo "<td>
                            <a href='edit_grn.php?grn_no={$row['grn_no']}' class='btn btn-primary'>Edit</a>
                            <a href='delete_grn.php?grn_no={$row['grn_no']}' class='btn btn-danger'>Delete</a>
                          </td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='6' class='text-center'>No GRNs found</td></tr>";
            }

            $conn->close();
            ?>
        </tbody>
    </table>
</div>

<script>
$(document).ready(function() {
    $('#searchInput').on('keyup', function() {
        var value = $(this).val().toLowerCase();
        $('#grnTable tbody tr').filter(function() {
            $(this).toggle($(this).find('td:first').text().toLowerCase().indexOf(value) > -1)
        });
    });
});
</script>
</body>
</html>
